/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.monster.BaseIceMob;
import twilightforest.init.TFItems;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;

public class SnowGuardian
extends BaseIceMob {
    public SnowGuardian(EntityType<? extends SnowGuardian> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MAX_HEALTH, 10.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.SNOW_GUARDIAN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.SNOW_GUARDIAN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.SNOW_GUARDIAN_DEATH.get();
    }

    public float getVoicePitch() {
        return (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 0.8f;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        int type = random.nextInt(4);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)this.makeItemForSlot(EquipmentSlot.MAINHAND, type)));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)this.makeItemForSlot(EquipmentSlot.CHEST, type)));
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)this.makeItemForSlot(EquipmentSlot.HEAD, type)));
    }

    private Item makeItemForSlot(EquipmentSlot slot, int type) {
        return switch (slot) {
            default -> {
                switch (type) {
                    default: {
                        yield (Item)TFItems.IRONWOOD_SWORD.get();
                    }
                    case 1: {
                        yield (Item)TFItems.STEELEAF_SWORD.get();
                    }
                    case 2: 
                    case 3: 
                }
                yield (Item)TFItems.KNIGHTMETAL_SWORD.get();
            }
            case EquipmentSlot.FEET -> {
                switch (type) {
                    default: {
                        yield (ArmorItem)TFItems.IRONWOOD_BOOTS.get();
                    }
                    case 1: {
                        yield (ArmorItem)TFItems.STEELEAF_BOOTS.get();
                    }
                    case 2: {
                        yield (ArmorItem)TFItems.KNIGHTMETAL_BOOTS.get();
                    }
                    case 3: 
                }
                yield (ArmorItem)TFItems.ARCTIC_BOOTS.get();
            }
            case EquipmentSlot.LEGS -> {
                switch (type) {
                    default: {
                        yield (ArmorItem)TFItems.IRONWOOD_LEGGINGS.get();
                    }
                    case 1: {
                        yield (ArmorItem)TFItems.STEELEAF_LEGGINGS.get();
                    }
                    case 2: {
                        yield (ArmorItem)TFItems.KNIGHTMETAL_LEGGINGS.get();
                    }
                    case 3: 
                }
                yield (ArmorItem)TFItems.ARCTIC_LEGGINGS.get();
            }
            case EquipmentSlot.CHEST -> {
                switch (type) {
                    default: {
                        yield (ArmorItem)TFItems.IRONWOOD_CHESTPLATE.get();
                    }
                    case 1: {
                        yield (ArmorItem)TFItems.STEELEAF_CHESTPLATE.get();
                    }
                    case 2: {
                        yield (ArmorItem)TFItems.KNIGHTMETAL_CHESTPLATE.get();
                    }
                    case 3: 
                }
                yield (ArmorItem)TFItems.ARCTIC_CHESTPLATE.get();
            }
            case EquipmentSlot.HEAD -> {
                switch (type) {
                    default: {
                        yield (ArmorItem)TFItems.IRONWOOD_HELMET.get();
                    }
                    case 1: {
                        yield (ArmorItem)TFItems.STEELEAF_HELMET.get();
                    }
                    case 2: {
                        yield (ArmorItem)TFItems.KNIGHTMETAL_HELMET.get();
                    }
                    case 3: 
                }
                yield (ArmorItem)TFItems.ARCTIC_HELMET.get();
            }
        };
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData data = super.finalizeSpawn(accessor, difficulty, reason, spawnDataIn);
        this.populateDefaultEquipmentSlots(accessor.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(accessor, accessor.getRandom(), difficulty);
        return data;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            for (int i = 0; i < 3; ++i) {
                float px = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.3f;
                float py = this.getEyeHeight() + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.5f;
                float pz = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.3f;
                this.level().addParticle((ParticleOptions)TFParticleType.SNOW_GUARDIAN.get(), this.xOld + (double)px, this.yOld + (double)py, this.zOld + (double)pz, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }
}

