/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import twilightforest.entity.boss.UrGhast;
import twilightforest.entity.projectile.ITFProjectile;

public class UrGhastFireball
extends LargeFireball
implements ITFProjectile {
    private final int power;

    public UrGhastFireball(Level world, UrGhast entityTFTowerBoss, double x, double y, double z, int power) {
        super(world, (LivingEntity)entityTFTowerBoss, new Vec3(x, y, z), power);
        this.power = power;
    }

    protected void onHit(HitResult pResult) {
        HitResult.Type hitresult$type = pResult.getType();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)pResult);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, pResult.getLocation(), GameEvent.Context.of((Entity)this, null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)pResult;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.getBlockPos();
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockpos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockpos)));
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (!(result.getEntity() instanceof AbstractHurtingProjectile)) {
                Entity entity1 = result.getEntity();
                Entity owner = this.getOwner();
                DamageSource source = this.damageSources().fireball((Fireball)this, owner);
                entity1.hurt(source, 16.0f);
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity1, (DamageSource)source);
                boolean flag = EventHooks.canEntityGrief((Level)this.level(), (Entity)this.getOwner());
                this.level().explode(null, this.getX(), this.getY(), this.getZ(), (float)this.power, flag, Level.ExplosionInteraction.NONE);
                this.discard();
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        boolean flag = EventHooks.canEntityGrief((Level)this.level(), (Entity)this.getOwner());
        this.level().explode(null, this.getX(), this.getY(), this.getZ(), (float)this.power, flag, Level.ExplosionInteraction.NONE);
        this.discard();
    }

    public void shoot(double x, double y, double z, float scale, float dist) {
        Vec3 vec3d = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)dist, this.random.nextGaussian() * (double)0.0075f * (double)dist, this.random.nextGaussian() * (double)0.0075f * (double)dist).scale((double)scale);
        this.setDeltaMovement(vec3d);
        float f = Mth.sqrt((float)((float)this.distanceToSqr(vec3d)));
        this.setYRot((float)(Mth.atan2((double)vec3d.x(), (double)z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3d.y(), (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }
}

