/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.apache.commons.lang3.text.WordUtils;
import twilightforest.block.AbstractSkullCandleBlock;

public class SkullCandleItem
extends StandingAndWallBlockItem
implements Equipable {
    public SkullCandleItem(AbstractSkullCandleBlock floor, AbstractSkullCandleBlock wall, Item.Properties properties) {
        super((Block)floor, (Block)wall, properties, Direction.DOWN);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag;
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null && !data.isEmpty() && (tag = data.copyTag()).contains("CandleColor") && tag.contains("CandleAmount")) {
            tooltip.add((Component)Component.translatable((String)(tag.getInt("CandleAmount") > 1 ? "item.twilightforest.skull_candle.desc.multiple" : "item.twilightforest.skull_candle.desc"), (Object[])new Object[]{String.valueOf(tag.getInt("CandleAmount")), WordUtils.capitalize((String)AbstractSkullCandleBlock.CandleColors.colorFromInt(tag.getInt("CandleColor")).getSerializedName().replace("\"", "").replace("_", " "))}).withStyle(ChatFormatting.GRAY));
        }
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return this.swapWithEquipmentSlot((Item)this, level, player, hand);
    }

    public Component getName(ItemStack stack) {
        ResolvableProfile resolvableprofile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        return resolvableprofile != null && resolvableprofile.name().isPresent() ? Component.translatable((String)(this.getDescriptionId() + ".named"), (Object[])new Object[]{resolvableprofile.name().get()}) : super.getName(stack);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        ResolvableProfile resolvableprofile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        if (resolvableprofile != null && !resolvableprofile.isResolved()) {
            resolvableprofile.resolve().thenAcceptAsync(profile -> stack.set(DataComponents.PROFILE, profile), SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        }
    }
}

