/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import twilightforest.init.TFLoot;

public class LootingEnchantNumberProvider
implements NumberProvider {
    public static final MapCodec<LootingEnchantNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(provider -> provider.enchantment), (App)NumberProviders.CODEC.fieldOf("base_value").forGetter(provider -> provider.baseValue)).apply((Applicative)instance, LootingEnchantNumberProvider::new));
    private final Holder<Enchantment> enchantment;
    private final NumberProvider baseValue;

    protected LootingEnchantNumberProvider(Holder<Enchantment> enchantment, NumberProvider baseValue) {
        this.enchantment = enchantment;
        this.baseValue = baseValue;
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)TFLoot.LOOTING_ROLLS.get();
    }

    public static LootingEnchantNumberProvider applyLootingLevelTo(HolderLookup.Provider provider, NumberProvider baseValue) {
        HolderLookup.RegistryLookup registrylookup = provider.lookupOrThrow(Registries.ENCHANTMENT);
        return new LootingEnchantNumberProvider((Holder<Enchantment>)registrylookup.getOrThrow(Enchantments.LOOTING), baseValue);
    }

    public float getFloat(LootContext context) {
        Object object = context.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        if (object instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)object;
            return (float)EnchantmentHelper.getEnchantmentLevel(this.enchantment, (LivingEntity)living) + this.baseValue.getFloat(context);
        }
        return this.baseValue.getFloat(context);
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.baseValue.getReferencedContextParams();
    }
}

