/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;
import twilightforest.client.particle.data.LeafParticleData;

public record SpawnFallenLeafFromPacket(BlockPos pos, Vec3 motion) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpawnFallenLeafFromPacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("spawn_fallen_leaf"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpawnFallenLeafFromPacket> STREAM_CODEC = CustomPacketPayload.codec(SpawnFallenLeafFromPacket::write, SpawnFallenLeafFromPacket::new);

    public SpawnFallenLeafFromPacket(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos());
        buf.writeDouble(this.motion().x());
        buf.writeDouble(this.motion().y());
        buf.writeDouble(this.motion().z());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SpawnFallenLeafFromPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Level level = ctx.player().level();
            Random rand = new Random();
            int color = Minecraft.getInstance().getBlockColors().getColor(Blocks.OAK_LEAVES.defaultBlockState(), (BlockAndTintGetter)level, message.pos(), 0);
            int r = Mth.clamp((int)((color >> 16 & 0xFF) + rand.nextInt(34) - 17), (int)0, (int)255);
            int g = Mth.clamp((int)((color >> 8 & 0xFF) + rand.nextInt(34) - 17), (int)0, (int)255);
            int b = Mth.clamp((int)((color & 0xFF) + rand.nextInt(34) - 17), (int)0, (int)255);
            level.addParticle((ParticleOptions)new LeafParticleData(r, g, b), (double)((float)message.pos().getX() + level.getRandom().nextFloat()), (double)message.pos().getY(), (double)((float)message.pos().getZ() + level.getRandom().nextFloat()), (double)(level.getRandom().nextFloat() * -0.5f) * message.motion().x(), (double)(level.getRandom().nextFloat() * 0.5f + 0.25f), (double)(level.getRandom().nextFloat() * -0.5f) * message.motion().z());
        });
    }
}

