/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.neoforge.common.world.PieceBeardifierModifier;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import twilightforest.TFRegistries;
import twilightforest.beanification.Autowired;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.init.custom.WoodPalettes;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.util.jigsaw.JigsawRecord;
import twilightforest.world.components.processors.WoodMultiPaletteSwizzle;
import twilightforest.world.components.structures.TwilightJigsawPiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerUtil;

public class LichTowerSpawnerBridge
extends TwilightJigsawPiece
implements PieceBeardifierModifier {
    @Autowired
    private static LichTowerUtil lichTowerUtil;
    private final boolean invertedPalette;

    public LichTowerSpawnerBridge(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_SPAWNER_BRIDGE.get(), compoundTag, ctx, LichTowerSpawnerBridge.readSettings(compoundTag));
        LichTowerUtil.addDefaultProcessors(this.placeSettings.addProcessor(lichTowerUtil.getCentralBridgeSpawnerProcessor()));
        this.invertedPalette = compoundTag.getBoolean("inverted");
        if (this.invertedPalette) {
            RegistryAccess registryAccess = ctx.registryAccess();
            LichTowerSpawnerBridge.addInvertedWoodProcessors(registryAccess, this.placeSettings);
        }
    }

    private static void addInvertedWoodProcessors(RegistryAccess registryAccess, StructurePlaceSettings placeSettings) {
        Optional woodPalettes = registryAccess.registry(TFRegistries.Keys.WOOD_PALETTES);
        if (woodPalettes.isPresent()) {
            Registry woodPaletteRegistry = (Registry)woodPalettes.get();
            Holder.Reference twiOak = woodPaletteRegistry.getHolderOrThrow(WoodPalettes.TWILIGHT_OAK);
            Holder.Reference canopy = woodPaletteRegistry.getHolderOrThrow(WoodPalettes.CANOPY);
            placeSettings.addProcessor((StructureProcessor)new WoodMultiPaletteSwizzle(List.of(Pair.of((Object)twiOak, (Object)canopy), Pair.of((Object)canopy, (Object)twiOak))));
        }
    }

    public LichTowerSpawnerBridge(int genDepth, StructureTemplateManager structureManager, ResourceLocation templateLocation, JigsawPlaceContext jigsawContext, boolean invertedPalette) {
        super((StructurePieceType)TFStructurePieceTypes.LICH_SPAWNER_BRIDGE.get(), genDepth, structureManager, templateLocation, jigsawContext);
        LichTowerUtil.addDefaultProcessors(this.placeSettings.addProcessor(lichTowerUtil.getCentralBridgeSpawnerProcessor()));
        this.invertedPalette = invertedPalette;
        if (this.invertedPalette) {
            RegistryAccess.Frozen registryAccess = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer()).registryAccess();
            LichTowerSpawnerBridge.addInvertedWoodProcessors((RegistryAccess)registryAccess, this.placeSettings);
        }
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.addAdditionalSaveData(ctx, structureTag);
        structureTag.putBoolean("inverted", this.invertedPalette);
    }

    @Override
    public BoundingBox getBeardifierBox() {
        return this.boundingBox;
    }

    @Override
    public TerrainAdjustment getTerrainAdjustment() {
        return TerrainAdjustment.NONE;
    }

    @Override
    public int getGroundLevelDelta() {
        return 0;
    }

    @Override
    protected void processJigsaw(StructurePiece parent, StructurePieceAccessor pieceAccessor, RandomSource random, JigsawRecord connection, int jigsawIndex) {
    }
}

