/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.processing.freeze;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.lang.Lang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import plus.dragons.createdragonsplus.data.internal.CDPLang;

public enum FreezeCondition implements StringRepresentable
{
    PASSIVE(0xFFFFFF),
    FROZEN(9100520),
    SUPERFROZEN(6067176);

    public static final Codec<FreezeCondition> CODEC;
    public static final StreamCodec<ByteBuf, FreezeCondition> STREAM_CODEC;
    private final int color;

    private FreezeCondition(int color) {
        this.color = color;
    }

    public boolean testFreezer(float freeze) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (freeze >= 0.0f) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (freeze >= 1.0f) {
                    yield true;
                }
                yield false;
            }
            case 2 -> freeze >= 2.0f;
        };
    }

    public Component getComponent() {
        return CDPLang.translate("recipe.freeze_condition", new Object[0]).color(this.color).component();
    }

    public int getColor() {
        return this.color;
    }

    public String getSerializedName() {
        return Lang.asId((String)this.name());
    }

    static {
        CODEC = StringRepresentable.fromEnum(FreezeCondition::values);
        STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(FreezeCondition.class);
    }
}

