/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.recipe;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.data.recipe.BaseSingleItemRecipeBuilder;

public class SingleItemRecipeBuilder
extends BaseSingleItemRecipeBuilder<SingleItemRecipe, SingleItemRecipeBuilder> {
    private final SingleItemRecipe.Factory<?> factory;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private String group = "";

    public SingleItemRecipeBuilder(@Nullable String directory, SingleItemRecipe.Factory<?> factory) {
        super(directory);
        this.factory = factory;
    }

    public SingleItemRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public SingleItemRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    @Override
    protected SingleItemRecipeBuilder builder() {
        return this;
    }

    @Override
    public RecipeHolder<SingleItemRecipe> build() {
        if (this.id == null) {
            this.id = ((ResourceKey)this.result.getItemHolder().unwrapKey().orElseThrow()).location();
        }
        SingleItemRecipe recipe = this.factory.create(this.group, this.ingredient, this.result);
        return new RecipeHolder(this.id, (Recipe)recipe);
    }

    @Override
    @Nullable
    public AdvancementHolder buildAdvancement() {
        if (this.id == null) {
            this.id = ((ResourceKey)this.result.getItemHolder().unwrapKey().orElseThrow()).location();
        }
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)this.id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)this.id)).requirements(AdvancementRequirements.Strategy.OR);
        if (!this.criteria.isEmpty()) {
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        }
        return builder.build(this.id.withPrefix("recipes/"));
    }
}

