/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.recipe.integration;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IntegrationIngredient {
    public static Ingredient of(String mod, String name) {
        return IntegrationIngredient.of(ResourceLocation.fromNamespaceAndPath((String)mod, (String)name));
    }

    public static Ingredient of(ResourceLocation location) {
        return Ingredient.fromValues(Stream.of(new Value(location)));
    }

    public static Ingredient of(ResourceLocation ... locations) {
        return Ingredient.fromValues(Arrays.stream(locations).map(Value::new));
    }

    public record Value(ResourceLocation location) implements Ingredient.Value
    {
        public static final MapCodec<Value> MAP_CODEC = ResourceLocation.CODEC.fieldOf("item").xmap(Value::new, Value::location);

        public Collection<ItemStack> getItems() {
            return List.of();
        }
    }
}

