/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;

public class FlatTopBarrelToggleRecipe
extends CustomRecipe {
    public FlatTopBarrelToggleRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        boolean barrelFound = false;
        for (int i = 0; i < input.size(); ++i) {
            BlockItem blockItem;
            Item item;
            ItemStack item2 = input.getItem(i);
            if (item2.isEmpty()) continue;
            if (!barrelFound && (item = item2.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof BarrelBlock) {
                barrelFound = true;
                continue;
            }
            return false;
        }
        return barrelFound;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        for (int i = 0; i < input.size(); ++i) {
            BlockItem blockItem;
            Item item;
            ItemStack item2 = input.getItem(i);
            if (item2.isEmpty() || !((item = item2.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof BarrelBlock)) continue;
            ItemStack result = item2.copy();
            result.setCount(1);
            BarrelBlockItem.toggleFlatTop(result);
            return result;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModBlocks.FLAT_TOP_BARREL_TOGGLE_RECIPE_SERIALIZER.get();
    }
}

