/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.container;

import com.blakebr0.cucumber.container.BaseContainerMenu;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugmentProvider;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.container.slot.AugmentSlot;
import com.blakebr0.mysticalagriculture.container.slot.ElementSlot;
import com.blakebr0.mysticalagriculture.container.slot.TinkerableSlot;
import com.blakebr0.mysticalagriculture.init.ModMenuTypes;
import com.blakebr0.mysticalagriculture.tileentity.TinkeringTableTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class TinkeringTableContainer
extends BaseContainerMenu {
    private final IItemHandlerModifiable inventory;

    private TinkeringTableContainer(MenuType<?> type, int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(type, id, playerInventory, (IItemHandlerModifiable)TinkeringTableTileEntity.createInventoryHandler(), buffer.readBlockPos());
    }

    private TinkeringTableContainer(MenuType<?> type, int id, Inventory playerInventory, IItemHandlerModifiable inventory, BlockPos pos) {
        super(type, id, pos);
        this.inventory = inventory;
        this.addSlot((Slot)new TinkerableSlot((AbstractContainerMenu)this, (IItemHandler)inventory, 0, 80, 49));
        this.addSlot((Slot)new AugmentSlot((AbstractContainerMenu)this, (IItemHandler)inventory, 1, 140, 36, 0));
        this.addSlot((Slot)new AugmentSlot((AbstractContainerMenu)this, (IItemHandler)inventory, 2, 140, 62, 1));
        this.addSlot((Slot)new ElementSlot((AbstractContainerMenu)this, (IItemHandler)inventory, 3, 20, 18));
        this.addSlot((Slot)new ElementSlot((AbstractContainerMenu)this, (IItemHandler)inventory, 4, 20, 39));
        this.addSlot((Slot)new ElementSlot((AbstractContainerMenu)this, (IItemHandler)inventory, 5, 20, 60));
        this.addSlot((Slot)new ElementSlot((AbstractContainerMenu)this, (IItemHandler)inventory, 6, 20, 81));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 115 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 8 + l * 18, 173));
        }
    }

    public void slotsChanged(Container inventory) {
        ItemStack tinkerable = this.inventory.getStackInSlot(0);
        if (!tinkerable.isEmpty()) {
            for (int i = 0; i < 2; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i + 1);
                Item item = stack.getItem();
                Augment augmentInSlot = AugmentUtils.getAugment(tinkerable, i);
                if (!stack.isEmpty() && item instanceof IAugmentProvider) {
                    Augment augment = ((IAugmentProvider)item).getAugment();
                    if (augment == augmentInSlot) continue;
                    AugmentUtils.addAugment(tinkerable, augment, i);
                    continue;
                }
                if (augmentInSlot == null) continue;
                AugmentUtils.removeAugment(tinkerable, i);
            }
        }
        super.slotsChanged(inventory);
    }

    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotNumber == 0) {
                if (!this.moveItemStackTo(itemstack1, 7, 43, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotNumber >= 7 && slotNumber < 43 ? !this.moveItemStackTo(itemstack1, 0, 7, false) : !this.moveItemStackTo(itemstack1, 7, 43, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public static TinkeringTableContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new TinkeringTableContainer((MenuType)ModMenuTypes.TINKERING_TABLE.get(), windowId, playerInventory, buffer);
    }

    public static TinkeringTableContainer create(int windowId, Inventory playerInventory, IItemHandlerModifiable inventory, BlockPos pos) {
        return new TinkeringTableContainer((MenuType)ModMenuTypes.TINKERING_TABLE.get(), windowId, playerInventory, inventory, pos);
    }
}

