/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.lib;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureTags;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum ModItemTier implements Tier
{
    INFERIUM(MysticalAgricultureTags.Blocks.INCORRECT_FOR_INFERIUM_TOOL, 2000, 9.0f, 4.0f, 12, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.INFERIUM_INGOT.get()})),
    PRUDENTIUM(MysticalAgricultureTags.Blocks.INCORRECT_FOR_PRUDENTIUM_TOOL, 2800, 11.0f, 6.0f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PRUDENTIUM_INGOT.get()})),
    TERTIUM(MysticalAgricultureTags.Blocks.INCORRECT_FOR_TERTIUM_TOOL, 4000, 14.0f, 9.0f, 16, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TERTIUM_INGOT.get()})),
    IMPERIUM(MysticalAgricultureTags.Blocks.INCORRECT_FOR_IMPERIUM_TOOL, 6000, 19.0f, 13.0f, 18, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.IMPERIUM_INGOT.get()})),
    SUPREMIUM(MysticalAgricultureTags.Blocks.INCORRECT_FOR_SUPREMIUM_TOOL, 0, 25.0f, 20.0f, 20, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SUPREMIUM_INGOT.get()})),
    AWAKENED_SUPREMIUM(MysticalAgricultureTags.Blocks.INCORRECT_FOR_AWAKENED_SUPREMIUM_TOOL, 0, 30.0f, 25.0f, 22, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.AWAKENED_SUPREMIUM_INGOT.get()})),
    SOULIUM(MysticalAgricultureTags.Blocks.INCORRECT_FOR_SOULIUM_TOOL, 400, 5.0f, 3.0f, 15, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SOULIUM_INGOT.get()}));

    private final TagKey<Block> incorrectBlocksForDrops;
    private final int maxUses;
    private final float efficiency;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<Ingredient> repairMaterial;

    private ModItemTier(TagKey<Block> incorrectBlocksForDrops, int maxUses, float efficiency, float attackDamage, int enchantability, Supplier<Ingredient> repairMaterial) {
        this.incorrectBlocksForDrops = incorrectBlocksForDrops;
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.enchantability = enchantability;
        this.repairMaterial = Suppliers.memoize(repairMaterial::get);
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getUses() {
        return this.maxUses;
    }

    public float getSpeed() {
        return this.efficiency;
    }

    public float getAttackDamageBonus() {
        return this.attackDamage;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public Ingredient getRepairIngredient() {
        return this.repairMaterial.get();
    }
}

