/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICachedRecipeHolder<RECIPE extends MekanismRecipe<?>> {
    @Nullable
    default public CachedRecipe<RECIPE> getUpdatedCache(int cacheIndex) {
        CachedRecipe<RECIPE> currentCache;
        boolean cacheInvalid = this.invalidateCache();
        CachedRecipe<RECIPE> cachedRecipe = currentCache = cacheInvalid ? null : this.getCachedRecipe(cacheIndex);
        if (!(currentCache != null && currentCache.isInputValid() || !cacheInvalid && this.hasNoRecipe(cacheIndex))) {
            RECIPE recipe = this.getRecipe(cacheIndex);
            if (recipe == null) {
                this.setHasNoRecipe(cacheIndex);
            } else {
                CachedRecipe<RECIPE> cached = this.createNewCachedRecipe(recipe, cacheIndex);
                if (currentCache == null || cached != null) {
                    if (currentCache == null && cached != null) {
                        this.loadSavedData(cached, cacheIndex);
                    }
                    return cached;
                }
            }
        }
        return currentCache;
    }

    default public void loadSavedData(@NotNull CachedRecipe<RECIPE> cached, int cacheIndex) {
        cached.loadSavedOperatingTicks(this.getSavedOperatingTicks(cacheIndex));
    }

    default public int getSavedOperatingTicks(int cacheIndex) {
        return 0;
    }

    @Nullable
    public CachedRecipe<RECIPE> getCachedRecipe(int var1);

    @Nullable
    public RECIPE getRecipe(int var1);

    @Nullable
    public CachedRecipe<RECIPE> createNewCachedRecipe(@NotNull RECIPE var1, int var2);

    default public boolean invalidateCache() {
        return false;
    }

    default public void setHasNoRecipe(int cacheIndex) {
    }

    default public boolean hasNoRecipe(int cacheIndex) {
        return false;
    }
}

