/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.RegistryUtils;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ChemicalStackHelper
implements IIngredientHelper<ChemicalStack> {
    @Nullable
    private IColorHelper colorHelper;

    void setColorHelper(IColorHelper colorHelper) {
        this.colorHelper = colorHelper;
    }

    public String getDisplayName(ChemicalStack ingredient) {
        return TextComponentUtil.build(ingredient).getString();
    }

    @Deprecated(forRemoval=true, since="JEI version 19.9.0")
    public String getUniqueId(ChemicalStack ingredient, UidContext context) {
        return "chemical:" + String.valueOf(ingredient.getChemical());
    }

    public Object getUid(ChemicalStack ingredient, UidContext context) {
        return ingredient.getChemical();
    }

    public ResourceLocation getResourceLocation(ChemicalStack ingredient) {
        return RegistryUtils.getName(ingredient.getChemicalHolder(), MekanismAPI.CHEMICAL_REGISTRY);
    }

    public ItemStack getCheatItemStack(ChemicalStack ingredient) {
        return ChemicalUtil.getFilledVariant(MekanismBlocks.CREATIVE_CHEMICAL_TANK.getItemHolder(), ingredient.getChemicalHolder());
    }

    public ChemicalStack normalizeIngredient(ChemicalStack ingredient) {
        return ingredient.copyWithAmount(1000L);
    }

    public boolean isValidIngredient(ChemicalStack ingredient) {
        return !ingredient.isEmpty();
    }

    public Iterable<Integer> getColors(ChemicalStack ingredient) {
        if (this.colorHelper == null) {
            return super.getColors((Object)ingredient);
        }
        return this.colorHelper.getColors(MekanismRenderer.getChemicalTexture(ingredient.getChemicalHolder()), ingredient.getChemicalTint(), 1);
    }

    public IIngredientType<ChemicalStack> getIngredientType() {
        return MekanismJEI.TYPE_CHEMICAL;
    }

    public ChemicalStack copyIngredient(ChemicalStack ingredient) {
        return ingredient.copy();
    }

    public Stream<ResourceLocation> getTagStream(ChemicalStack ingredient) {
        return ingredient.getTags().map(TagKey::location);
    }

    public boolean isHiddenFromRecipeViewersByTags(ChemicalStack ingredient) {
        return ingredient.is(MekanismAPITags.Chemicals.HIDDEN_FROM_RECIPE_VIEWERS);
    }

    public Optional<TagKey<?>> getTagKeyEquivalent(Collection<ChemicalStack> stacks) {
        if (stacks.size() < 2) {
            return Optional.empty();
        }
        List<Holder> values = stacks.stream().map(ChemicalStack::getChemicalHolder).distinct().toList();
        int expected = values.size();
        if (expected != stacks.size()) {
            return Optional.empty();
        }
        for (TagKey tagKey : values.getFirst().tags().toList()) {
            HolderSet.Named tag;
            Optional optionalTag = MekanismAPI.CHEMICAL_REGISTRY.getTag(tagKey);
            if (!optionalTag.isPresent() || (tag = (HolderSet.Named)optionalTag.get()).size() != expected) continue;
            if (!values.stream().allMatch(arg_0 -> ((HolderSet.Named)tag).contains(arg_0))) continue;
            return Optional.of(tagKey);
        }
        return Optional.empty();
    }

    public String getErrorInfo(@Nullable ChemicalStack ingredient) {
        if (ingredient == null) {
            ingredient = ChemicalStack.EMPTY;
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ChemicalStack.class);
        Holder<Chemical> chemical = ingredient.getChemicalHolder();
        toStringHelper.add("Chemical", (Object)(chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY) ? "none" : TextComponentUtil.build(chemical).getString()));
        if (!ingredient.isEmpty()) {
            toStringHelper.add("Amount", ingredient.getAmount());
        }
        return toStringHelper.toString();
    }
}

