/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.attribute.HeatedCoolant;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.INamedRVRecipe;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.util.HeatUtils;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import org.jetbrains.annotations.Nullable;

public record BoilerRecipeViewerRecipe(ResourceLocation id, @Nullable ChemicalStackIngredient superHeatedCoolant, FluidStackIngredient water, ChemicalStack steam, ChemicalStack cooledCoolant, double temperature) implements INamedRVRecipe
{
    private static final int WATER_AMOUNT = 1;
    public static final Codec<BoilerRecipeViewerRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(BoilerRecipeViewerRecipe::id), (App)ChemicalStackIngredient.CODEC.optionalFieldOf("chemical_input").forGetter(recipe -> Optional.ofNullable(recipe.superHeatedCoolant())), (App)FluidStackIngredient.CODEC.optionalFieldOf("fluid_input", (Object)IngredientCreatorAccess.fluid().from(FluidTags.WATER, 1)).forGetter(BoilerRecipeViewerRecipe::water), (App)ChemicalStack.CODEC.optionalFieldOf("main_output", (Object)MekanismChemicals.STEAM.asStack(1L)).forGetter(BoilerRecipeViewerRecipe::steam), (App)ChemicalStack.CODEC.optionalFieldOf("secondary_output", (Object)ChemicalStack.EMPTY).forGetter(BoilerRecipeViewerRecipe::cooledCoolant), (App)Codec.DOUBLE.optionalFieldOf("temperature", (Object)HeatUtils.BASE_BOIL_TEMP).forGetter(BoilerRecipeViewerRecipe::temperature)).apply((Applicative)instance, (id, superHeatedCoolant, water, steam, cooledCoolant, temperature) -> new BoilerRecipeViewerRecipe((ResourceLocation)id, superHeatedCoolant.orElse(null), (FluidStackIngredient)water, (ChemicalStack)steam, (ChemicalStack)cooledCoolant, (double)temperature)));

    public static List<BoilerRecipeViewerRecipe> getBoilerRecipes() {
        double waterToSteamHeatNecessary = 1.0 * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
        ArrayList<BoilerRecipeViewerRecipe> recipes = new ArrayList<BoilerRecipeViewerRecipe>();
        InputIngredient water = IngredientCreatorAccess.fluid().from(FluidTags.WATER, 1);
        ChemicalStack steam = MekanismChemicals.STEAM.asStack(1L);
        recipes.add(new BoilerRecipeViewerRecipe(RecipeViewerUtils.synthetic(Mekanism.rl("water"), "boiler"), null, (FluidStackIngredient)water, steam, ChemicalStack.EMPTY, HeatUtils.BASE_BOIL_TEMP + waterToSteamHeatNecessary / (50.0 * MekanismConfig.general.boilerWaterConductivity.get())));
        for (Map.Entry entry : MekanismAPI.CHEMICAL_REGISTRY.getDataMap(IMekanismDataMapTypes.INSTANCE.heatedChemicalCoolant()).entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            HeatedCoolant coolant = (HeatedCoolant)entry.getValue();
            long coolantAmount = Math.round(waterToSteamHeatNecessary / coolant.thermalEnthalpy());
            recipes.add(new BoilerRecipeViewerRecipe(RecipeViewerUtils.synthetic(key.location(), "boiler", "mekanism"), IngredientCreatorAccess.chemicalStack().fromHolder((Holder<Chemical>)MekanismAPI.CHEMICAL_REGISTRY.getHolderOrThrow(key), coolantAmount), (FluidStackIngredient)water, steam, coolant.cool(coolantAmount), HeatUtils.BASE_BOIL_TEMP));
        }
        for (Chemical gas : MekanismAPI.CHEMICAL_REGISTRY) {
            ChemicalAttributes.HeatedCoolant heatedCoolant = gas.getLegacy(ChemicalAttributes.HeatedCoolant.class);
            if (heatedCoolant == null) continue;
            long coolantAmount = Math.round(waterToSteamHeatNecessary / heatedCoolant.getThermalEnthalpy());
            recipes.add(new BoilerRecipeViewerRecipe(RecipeViewerUtils.synthetic(gas.toString(), "boiler", "mekanism"), IngredientCreatorAccess.chemicalStack().from((IChemicalProvider)gas, coolantAmount), (FluidStackIngredient)water, steam, heatedCoolant.getCooledChemical().getStack(coolantAmount), HeatUtils.BASE_BOIL_TEMP));
        }
        return recipes;
    }
}

