/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.chemical;

import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.common.attachments.containers.ComponentBackedContainer;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.AttachedChemicals;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ComponentBackedChemicalTank
extends ComponentBackedContainer<ChemicalStack, AttachedChemicals>
implements IChemicalTank {
    private final BiPredicate<ChemicalStack, @NotNull AutomationType> canExtract;
    private final BiPredicate<ChemicalStack, @NotNull AutomationType> canInsert;
    private final Predicate<ChemicalStack> validator;
    @Nullable
    private final ChemicalAttributeValidator attributeValidator;
    private final LongSupplier capacity;
    private final LongSupplier rate;

    public ComponentBackedChemicalTank(ItemStack attachedTo, int tankIndex, BiPredicate<ChemicalStack, @NotNull AutomationType> canExtract, BiPredicate<ChemicalStack, @NotNull AutomationType> canInsert, Predicate<ChemicalStack> validator, LongSupplier rate, LongSupplier capacity, @Nullable ChemicalAttributeValidator attributeValidator) {
        super(attachedTo, tankIndex);
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.capacity = capacity;
        this.rate = rate;
        this.attributeValidator = attributeValidator;
    }

    @Override
    protected ChemicalStack copy(ChemicalStack toCopy) {
        return toCopy.copy();
    }

    @Override
    protected boolean isEmpty(ChemicalStack value) {
        return value.isEmpty();
    }

    @Override
    protected ContainerType<?, AttachedChemicals, ?> containerType() {
        return ContainerType.CHEMICAL;
    }

    @Override
    public ChemicalStack getStack() {
        return (ChemicalStack)this.getContents((AttachedChemicals)this.getAttached());
    }

    @Override
    public void setStack(ChemicalStack stack) {
        this.setStackUnchecked(stack);
    }

    @Override
    public void setStackUnchecked(ChemicalStack stack) {
        this.setContents((AttachedChemicals)this.getAttached(), stack);
    }

    @Override
    public ChemicalAttributeValidator getAttributeValidator() {
        return this.attributeValidator == null ? IChemicalTank.super.getAttributeValidator() : this.attributeValidator;
    }

    protected long getInsertRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Long.MAX_VALUE : this.rate.getAsLong();
    }

    protected long getExtractRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? Long.MAX_VALUE : this.rate.getAsLong();
    }

    @Override
    public long getCapacity() {
        return this.capacity.getAsLong();
    }

    @Override
    public boolean isValid(ChemicalStack stack) {
        return this.getAttributeValidator().process(stack) && this.validator.test(stack);
    }

    @Override
    public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty() || !this.isValid(stack) || !this.canInsert.test(stack, automationType)) {
            return stack;
        }
        AttachedChemicals attachedChemicals = (AttachedChemicals)this.getAttached();
        ChemicalStack stored = (ChemicalStack)this.getContents(attachedChemicals);
        long needed = Math.min(this.getInsertRate(automationType), this.getNeeded(stored));
        if (needed <= 0L) {
            return stack;
        }
        if (stored.isEmpty() || ChemicalStack.isSameChemical(stored, stack)) {
            long toAdd = Math.min(stack.getAmount(), needed);
            if (action.execute()) {
                this.setContents(attachedChemicals, stack.copyWithAmount(stored.getAmount() + toAdd));
            }
            return stack.copyWithAmount(stack.getAmount() - toAdd);
        }
        return stack;
    }

    @Override
    public final ChemicalStack extract(long amount, Action action, AutomationType automationType) {
        if (amount < 1L) {
            return ChemicalStack.EMPTY;
        }
        AttachedChemicals attachedChemicals = (AttachedChemicals)this.getAttached();
        return this.extract(attachedChemicals, (ChemicalStack)this.getContents(attachedChemicals), amount, action, automationType);
    }

    protected ChemicalStack extract(AttachedChemicals attachedChemicals, ChemicalStack stored, long amount, Action action, AutomationType automationType) {
        if (amount < 1L || stored.isEmpty() || !this.canExtract.test(stored, automationType)) {
            return ChemicalStack.EMPTY;
        }
        long size = Math.min(Math.min(this.getExtractRate(automationType), stored.getAmount()), amount);
        if (size == 0L) {
            return ChemicalStack.EMPTY;
        }
        ChemicalStack ret = stored.copyWithAmount(size);
        if (!ret.isEmpty() && action.execute()) {
            this.setContents(attachedChemicals, stored.copyWithAmount(stored.getAmount() - ret.getAmount()));
        }
        return ret;
    }

    @Override
    public final long setStackSize(long amount, Action action) {
        AttachedChemicals attachedChemicals = (AttachedChemicals)this.getAttached();
        return this.setStackSize(attachedChemicals, (ChemicalStack)this.getContents(attachedChemicals), amount, action);
    }

    protected long setStackSize(AttachedChemicals attachedChemicals, ChemicalStack stored, long amount, Action action) {
        if (stored.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setContents(attachedChemicals, ChemicalStack.EMPTY);
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (stored.getAmount() == amount || action.simulate()) {
            return amount;
        }
        this.setContents(attachedChemicals, stored.copyWithAmount(amount));
        return amount;
    }

    @Override
    public long growStack(long amount, Action action) {
        AttachedChemicals attachedChemicals = (AttachedChemicals)this.getAttached();
        ChemicalStack stored = (ChemicalStack)this.getContents(attachedChemicals);
        long current = stored.getAmount();
        if (current == 0L) {
            return 0L;
        }
        if (amount > 0L) {
            amount = Math.min(Math.min(amount, this.getNeeded(stored)), this.getInsertRate(null));
        } else if (amount < 0L) {
            amount = Math.max(amount, -this.getExtractRate(null));
        }
        long newSize = this.setStackSize(attachedChemicals, stored, current + amount, action);
        return newSize - current;
    }

    protected long getNeeded(ChemicalStack stored) {
        return Math.max(0L, this.getCapacity() - stored.getAmount());
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ChemicalStack stored = this.getStack();
        if (!stored.isEmpty()) {
            nbt.put("stored", stored.save(provider));
        }
        return nbt;
    }
}

