/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import mekanism.api.functions.FloatSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedValue;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CachedFloatValue
extends CachedValue<Double>
implements FloatSupplier {
    private boolean resolved;
    private float cachedValue;

    private CachedFloatValue(IMekanismConfig config, ModConfigSpec.ConfigValue<Double> internal) {
        super(config, internal);
    }

    public static CachedFloatValue wrap(IMekanismConfig config, ModConfigSpec.ConfigValue<Double> internal) {
        return new CachedFloatValue(config, internal);
    }

    public float getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return this.clampInternal((Double)this.internal.getDefault());
    }

    public float get() {
        if (!this.resolved) {
            this.cachedValue = this.clampInternal((Double)this.internal.get());
            this.resolved = true;
        }
        return this.cachedValue;
    }

    private float clampInternal(Double val) {
        if (val == null) {
            return 0.0f;
        }
        if (val > 3.4028234663852886E38) {
            return Float.MAX_VALUE;
        }
        if (val < -3.4028234663852886E38) {
            return -3.4028235E38f;
        }
        return val.floatValue();
    }

    @Override
    public float getAsFloat() {
        return this.get();
    }

    public void set(float value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    public void set(double value) {
        this.internal.set((Object)value);
        this.cachedValue = (float)value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        float oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

