/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.multiblock.TileEntitySuperheatingElement;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class BoilerValidator
extends CuboidStructureValidator<BoilerMultiblockData> {
    @Override
    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.getBlock();
        if (BlockType.is(block, MekanismBlockTypes.BOILER_CASING)) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is(block, MekanismBlockTypes.BOILER_VALVE)) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    @Override
    protected boolean validateInner(BlockState state, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        return BlockType.is(state.getBlock(), MekanismBlockTypes.PRESSURE_DISPERSER, MekanismBlockTypes.SUPERHEATING_ELEMENT);
    }

    @Override
    public FormationProtocol.FormationResult postcheck(BoilerMultiblockData structure, Long2ObjectMap<ChunkAccess> chunkMap) {
        LinkedHashSet<BlockPos> dispersers = new LinkedHashSet<BlockPos>();
        LinkedHashSet<BlockPos> elements = new LinkedHashSet<BlockPos>();
        for (BlockPos pos2 : structure.internalLocations) {
            BlockEntity tile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, pos2);
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(pos2);
                continue;
            }
            if (!(tile instanceof TileEntitySuperheatingElement)) continue;
            elements.add(pos2);
        }
        if (dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_NO_DISPERSER);
        }
        if (elements.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_SUPERHEATING);
        }
        BlockPos initDisperser = (BlockPos)dispersers.getFirst();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = 1; x < structure.length() - 1; ++x) {
            for (int z = 1; z < structure.width() - 1; ++z) {
                mutablePos.set(structure.renderLocation.getX() + x, initDisperser.getY(), structure.renderLocation.getZ() + z);
                TileEntityPressureDisperser tile = WorldUtils.getTileEntity(TileEntityPressureDisperser.class, (LevelAccessor)this.world, chunkMap, (BlockPos)mutablePos);
                if (tile == null) {
                    return FormationProtocol.FormationResult.fail((ILangEntry)MekanismLang.BOILER_INVALID_MISSING_DISPERSER, (BlockPos)mutablePos);
                }
                dispersers.remove(mutablePos);
            }
        }
        if (!dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_EXTRA_DISPERSER);
        }
        structure.superheatingElements = FormationProtocol.explore(this.world, chunkMap, (BlockPos)elements.getFirst(), initDisperser, (level, chunks, start, n, pos) -> pos.getY() < n.getY() && WorldUtils.getTileEntity(TileEntitySuperheatingElement.class, (LevelAccessor)level, (Long2ObjectMap<ChunkAccess>)chunks, pos) != null);
        if (elements.size() > structure.superheatingElements) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_SUPERHEATING);
        }
        BlockPos initAir = null;
        BlockPos.MutableBlockPos mutableAir = new BlockPos.MutableBlockPos();
        int totalAir = 0;
        for (int x = structure.renderLocation.getX(); x < structure.renderLocation.getX() + structure.length(); ++x) {
            for (int y = structure.renderLocation.getY(); y < initDisperser.getY(); ++y) {
                for (int z = structure.renderLocation.getZ(); z < structure.renderLocation.getZ() + structure.width(); ++z) {
                    mutableAir.set(x, y, z);
                    if (!this.isAirOrFrame(chunkMap, (BlockPos)mutableAir)) continue;
                    initAir = mutableAir.immutable();
                    ++totalAir;
                }
            }
        }
        BlockPos renderLocation = structure.renderLocation;
        record Data(int disperserY, BlockPos renderLoc, int volLength, int volWidth) {
        }
        Data data = new Data(initDisperser.getY(), renderLocation, structure.length(), structure.width());
        structure.setWaterVolume(FormationProtocol.explore(this.world, chunkMap, initAir, data, (level, chunks, start, d, pos) -> {
            BlockPos renderLoc = d.renderLoc();
            return pos.getY() >= renderLoc.getY() - 1 && pos.getY() < d.disperserY() && pos.getX() >= renderLoc.getX() && pos.getX() < renderLoc.getX() + d.volLength() && pos.getZ() >= renderLoc.getZ() && pos.getZ() < renderLoc.getZ() + d.volWidth() && this.isAirOrFrame((Long2ObjectMap<ChunkAccess>)chunks, pos);
        }));
        if (totalAir > structure.getWaterVolume()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_AIR_POCKETS);
        }
        int steamHeight = structure.renderLocation.getY() + structure.height() - 2 - initDisperser.getY();
        structure.setSteamVolume(structure.width() * structure.length() * steamHeight);
        structure.upperRenderLocation = new BlockPos(structure.renderLocation.getX(), initDisperser.getY() + 1, structure.renderLocation.getZ());
        return FormationProtocol.FormationResult.SUCCESS;
    }

    private boolean isAirOrFrame(Long2ObjectMap<ChunkAccess> chunkMap, BlockPos airPos) {
        Optional<BlockState> stateOptional = WorldUtils.getBlockState((LevelAccessor)this.world, chunkMap, airPos);
        return stateOptional.isPresent() && stateOptional.get().isAir() || this.isFrameCompatible(WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, airPos));
    }
}

