/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.attachments.qio.PortableDashboardContents;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PortableQIODashboardInventory
implements IQIOCraftingWindowHolder {
    private final QIOCraftingWindow[] craftingWindows;
    private final List<IInventorySlot> slots;
    private final ItemStack stack;
    @Nullable
    private final Level level;
    private boolean initializing;

    public PortableQIODashboardInventory(@Nullable Level level, ItemStack stack) {
        this.stack = stack;
        this.level = level;
        ArrayList<IInventorySlot> slots = new ArrayList<IInventorySlot>();
        this.craftingWindows = new QIOCraftingWindow[3];
        List<ItemStack> contents = ((PortableDashboardContents)stack.getOrDefault(MekanismDataComponents.QIO_DASHBOARD, (Object)PortableDashboardContents.EMPTY)).contents();
        this.initializing = true;
        for (int tableIndex = 0; tableIndex < this.craftingWindows.length; ++tableIndex) {
            QIOCraftingWindow craftingWindow;
            int finalTableIndex = tableIndex;
            this.craftingWindows[tableIndex] = craftingWindow = new QIOCraftingWindow(this, (byte)tableIndex, slot -> () -> {
                if (!this.initializing) {
                    ItemStack stored = this.craftingWindows[finalTableIndex].getInputSlot(slot).getStack().copy();
                    PortableDashboardContents content = (PortableDashboardContents)stack.getOrDefault(MekanismDataComponents.QIO_DASHBOARD, (Object)PortableDashboardContents.EMPTY);
                    stack.set(MekanismDataComponents.QIO_DASHBOARD, (Object)content.with(finalTableIndex, slot, stored));
                }
            });
            for (int slot2 = 0; slot2 < 9; ++slot2) {
                IInventorySlot inputSlot = craftingWindow.getInputSlot(slot2);
                slots.add(inputSlot);
                inputSlot.setStack(contents.get(tableIndex * 9 + slot2));
            }
            slots.add(craftingWindow.getOutputSlot());
        }
        this.slots = List.copyOf(slots);
        this.initializing = false;
    }

    public List<IInventorySlot> getSlots() {
        return this.slots;
    }

    @Override
    @Nullable
    public Level getLevel() {
        return this.level;
    }

    @Override
    public QIOCraftingWindow[] getCraftingWindows() {
        return this.craftingWindows;
    }

    @Override
    @Nullable
    public QIOFrequency getFrequency() {
        FrequencyAware frequencyAware;
        if (this.level != null && !this.level.isClientSide() && !this.stack.isEmpty() && (frequencyAware = (FrequencyAware)this.stack.get(MekanismDataComponents.QIO_FREQUENCY)) != null) {
            return (QIOFrequency)frequencyAware.getFrequency(this.stack, (DataComponentType)MekanismDataComponents.QIO_FREQUENCY.value());
        }
        return null;
    }

    @Override
    public void onContentsChanged() {
    }
}

