/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ItemStackToChemicalRecipe;
import mekanism.api.recipes.basic.BasicChemicalConversionRecipe;
import mekanism.api.recipes.basic.BasicChemicalOxidizerRecipe;
import mekanism.api.recipes.basic.BasicPigmentExtractingRecipe;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToChemical")
public abstract class ItemStackToChemicalRecipeManager
extends MekanismRecipeManager<SingleRecipeInput, ItemStackToChemicalRecipe> {
    protected ItemStackToChemicalRecipeManager(IMekanismRecipeTypeProvider<SingleRecipeInput, ItemStackToChemicalRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount input, ICrTChemicalStack output) {
        this.addRecipe(name, this.makeRecipe(input, output));
    }

    public final ItemStackToChemicalRecipe makeRecipe(IIngredientWithAmount input, ICrTChemicalStack output) {
        return this.makeRecipe(input, this.getAndValidateNotEmpty(output));
    }

    protected abstract ItemStackToChemicalRecipe makeRecipe(IIngredientWithAmount var1, ChemicalStack var2);

    @Override
    protected String describeOutputs(ItemStackToChemicalRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition());
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToChemical.PigmentExtracting")
    public static class PigmentExtractingRecipeManager
    extends ItemStackToChemicalRecipeManager {
        public static final PigmentExtractingRecipeManager INSTANCE = new PigmentExtractingRecipeManager();

        private PigmentExtractingRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleRecipeInput, ItemStackToChemicalRecipe, ?>)MekanismRecipeType.PIGMENT_EXTRACTING);
        }

        @Override
        protected ItemStackToChemicalRecipe makeRecipe(IIngredientWithAmount input, ChemicalStack output) {
            return new BasicPigmentExtractingRecipe(CrTUtils.fromCrT(input), output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToChemical.Oxidizing")
    public static class ChemicalOxidizerRecipeManager
    extends ItemStackToChemicalRecipeManager {
        public static final ChemicalOxidizerRecipeManager INSTANCE = new ChemicalOxidizerRecipeManager();

        private ChemicalOxidizerRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleRecipeInput, ItemStackToChemicalRecipe, ?>)MekanismRecipeType.OXIDIZING);
        }

        @Override
        protected ItemStackToChemicalRecipe makeRecipe(IIngredientWithAmount input, ChemicalStack output) {
            return new BasicChemicalOxidizerRecipe(CrTUtils.fromCrT(input), output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToChemical.ChemicalConversion")
    public static class ChemicalConversionRecipeManager
    extends ItemStackToChemicalRecipeManager {
        public static final ChemicalConversionRecipeManager INSTANCE = new ChemicalConversionRecipeManager();

        private ChemicalConversionRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleRecipeInput, ItemStackToChemicalRecipe, ?>)MekanismRecipeType.CHEMICAL_CONVERSION);
        }

        @Override
        protected ItemStackToChemicalRecipe makeRecipe(IIngredientWithAmount input, ChemicalStack output) {
            return new BasicChemicalConversionRecipe(CrTUtils.fromCrT(input), output);
        }
    }
}

