/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalRecipeData
implements RecipeUpgradeData<ChemicalRecipeData> {
    protected final List<IChemicalTank> tanks;

    public ChemicalRecipeData(List<IChemicalTank> tanks) {
        this.tanks = tanks;
    }

    @Override
    @Nullable
    public ChemicalRecipeData merge(ChemicalRecipeData other) {
        ArrayList<IChemicalTank> allTanks = new ArrayList<IChemicalTank>(this.tanks);
        allTanks.addAll(other.tanks);
        return new ChemicalRecipeData(allTanks);
    }

    @Override
    public boolean applyToStack(HolderLookup.Provider provider, ItemStack stack) {
        if (this.tanks.isEmpty()) {
            return true;
        }
        IMekanismChemicalHandler outputHandler = ContainerType.CHEMICAL.createHandler(stack);
        if (outputHandler == null) {
            return false;
        }
        for (IChemicalTank tank : this.tanks) {
            if (tank.isEmpty() || this.insertManualIntoOutputContainer(outputHandler, tank.getStack()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private ChemicalStack insertManualIntoOutputContainer(IMekanismChemicalHandler outputHandler, ChemicalStack chemical) {
        return ChemicalUtils.insert(chemical, null, outputHandler::getChemicalTanks, Action.EXECUTE, AutomationType.MANUAL);
    }
}

