/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.qio.DriveContents;
import mekanism.common.attachments.qio.DriveMetadata;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class QIORecipeData
implements RecipeUpgradeData<QIORecipeData> {
    private final Object2LongSortedMap<UUID> itemMap;
    private final long itemCount;

    QIORecipeData(DriveMetadata data, DriveContents contents) {
        this.itemCount = data.count();
        this.itemMap = contents.namedItemMap();
    }

    private QIORecipeData(Object2LongSortedMap<UUID> itemMap, long itemCount) {
        this.itemMap = itemMap;
        this.itemCount = itemCount;
    }

    @Override
    @Nullable
    public QIORecipeData merge(QIORecipeData other) {
        if (this.itemCount <= Long.MAX_VALUE - other.itemCount) {
            Object2LongSortedMap<UUID> smallerMap = other.itemMap;
            Object2LongSortedMap<UUID> largerMap = this.itemMap;
            if (largerMap.size() < smallerMap.size()) {
                smallerMap = this.itemMap;
                largerMap = other.itemMap;
            }
            Object2LongLinkedOpenHashMap fullItemMap = new Object2LongLinkedOpenHashMap(largerMap);
            ObjectIterator iterator = Object2LongMaps.fastIterator(smallerMap);
            while (iterator.hasNext()) {
                Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
                fullItemMap.mergeLong((Object)((UUID)entry.getKey()), entry.getLongValue(), Long::sum);
            }
            return new QIORecipeData((Object2LongSortedMap<UUID>)fullItemMap, this.itemCount + other.itemCount);
        }
        return null;
    }

    @Override
    public boolean applyToStack(HolderLookup.Provider provider, ItemStack stack) {
        if (this.itemMap.isEmpty()) {
            return this.itemCount == 0L;
        }
        IQIODriveItem driveItem = (IQIODriveItem)stack.getItem();
        if (this.itemCount == 0L || this.itemCount > driveItem.getCountCapacity(stack) || this.itemMap.size() > driveItem.getTypeCapacity(stack)) {
            return false;
        }
        stack.set(MekanismDataComponents.DRIVE_METADATA, (Object)new DriveMetadata(this.itemCount, this.itemMap.size()));
        stack.set(MekanismDataComponents.DRIVE_CONTENTS, (Object)new DriveContents(this.itemMap));
        return true;
    }
}

