/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.attachments.IAttachmentAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.creator.IContainerCreator;
import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.registration.MekanismDeferredHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRegistryObject<ITEM extends Item>
extends MekanismDeferredHolder<Item, ITEM>
implements ItemLike,
IHasTextComponent,
IHasTranslationKey {
    @Nullable
    private Map<ContainerType<?, ?, ?>, Supplier<? extends IContainerCreator<?, ?>>> defaultCreators;
    @Nullable
    private List<Consumer<RegisterCapabilitiesEvent>> containerCapabilities;

    public ItemRegistryObject(ResourceKey<Item> key) {
        super(key);
    }

    @NotNull
    public ITEM asItem() {
        return (ITEM)((Item)this.value());
    }

    public ItemStack asStack() {
        return this.asStack(1);
    }

    public ItemStack asStack(int count) {
        return new ItemStack((ItemLike)this.value(), count);
    }

    @Override
    @NotNull
    public String getTranslationKey() {
        return ((Item)this.value()).getDescriptionId();
    }

    @Override
    @NotNull
    public Component getTextComponent() {
        return ((Item)this.value()).getDescription();
    }

    @ApiStatus.Internal
    public <CONTAINER extends INBTSerializable<CompoundTag>> ItemRegistryObject<ITEM> addAttachmentOnlyContainers(ContainerType<CONTAINER, ?, ?> containerType, Supplier<IContainerCreator<? extends CONTAINER, ?>> defaultCreator) {
        if (this.defaultCreators == null) {
            this.defaultCreators = new LinkedHashMap();
        }
        if (this.defaultCreators.put(containerType, defaultCreator) != null) {
            throw new IllegalStateException("Duplicate attachments added for container type: " + String.valueOf(containerType.getComponentName()));
        }
        return this;
    }

    @ApiStatus.Internal
    public <CONTAINER extends INBTSerializable<CompoundTag>> ItemRegistryObject<ITEM> addAttachedContainerCapabilities(ContainerType<CONTAINER, ?, ?> containerType, Supplier<IContainerCreator<? extends CONTAINER, ?>> defaultCreator, IMekanismConfig ... requiredConfigs) {
        this.addAttachmentOnlyContainers(containerType, defaultCreator);
        return this.addContainerCapability(containerType, requiredConfigs);
    }

    @ApiStatus.Internal
    private ItemRegistryObject<ITEM> addContainerCapability(ContainerType<?, ?, ?> containerType, IMekanismConfig ... requiredConfigs) {
        if (this.containerCapabilities == null) {
            this.containerCapabilities = new ArrayList<Consumer<RegisterCapabilitiesEvent>>();
        }
        this.containerCapabilities.add(event -> containerType.registerItemCapabilities((RegisterCapabilitiesEvent)event, (Item)this.get(), false, requiredConfigs));
        return this;
    }

    @ApiStatus.Internal
    void registerCapabilities(RegisterCapabilitiesEvent event) {
        Object object = this.get();
        if (object instanceof ICapabilityAware) {
            ICapabilityAware capabilityAware = (ICapabilityAware)object;
            capabilityAware.attachCapabilities(event);
        }
        if (this.containerCapabilities != null) {
            for (Consumer<RegisterCapabilitiesEvent> consumer : this.containerCapabilities) {
                consumer.accept(event);
            }
            this.containerCapabilities = null;
        }
    }

    @ApiStatus.Internal
    void attachDefaultContainers(IEventBus eventBus) {
        Item item = (Item)this.get();
        if (item instanceof IAttachmentAware) {
            IAttachmentAware attachmentAware = (IAttachmentAware)item;
            attachmentAware.attachAttachments(eventBus);
        }
        if (this.defaultCreators != null) {
            for (Map.Entry<ContainerType<?, ?, ?>, Supplier<IContainerCreator<?, ?>>> entry : this.defaultCreators.entrySet()) {
                entry.getKey().addDefaultCreators(null, item, entry.getValue(), new IMekanismConfig[0]);
            }
            this.defaultCreators = null;
        }
    }
}

