/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct.magnet_card;

import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.stacks.AEKeyType;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import de.mari_023.ae2wtlib.api.AE2wtlibComponents;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class MagnetHost {
    public final ConfigInventory pickupConfig = ConfigInventory.configTypes((int)27).changeListener(this::updatePickupFilter).supportedTypes(AEKeyType.items(), new AEKeyType[0]).build();
    public final ConfigInventory insertConfig = ConfigInventory.configTypes((int)27).changeListener(this::updateInsertFilter).supportedTypes(AEKeyType.items(), new AEKeyType[0]).build();
    private IPartitionList pickupFilter = this.createFilter(this.pickupConfig);
    private IPartitionList insertFilter = this.createFilter(this.insertConfig);
    private final CraftingTerminalHandler ctHandler;

    public MagnetHost(CraftingTerminalHandler ctHandler) {
        this.ctHandler = ctHandler;
        this.pickupConfig.readFromChildTag((CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.PICKUP_CONFIG, (Object)new CompoundTag()), "", (HolderLookup.Provider)ctHandler.player.registryAccess());
        this.insertConfig.readFromChildTag((CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.INSERT_CONFIG, (Object)new CompoundTag()), "", (HolderLookup.Provider)ctHandler.player.registryAccess());
    }

    private IPartitionList createFilter(ConfigInventory config) {
        IPartitionList.Builder builder = IPartitionList.builder();
        builder.fuzzyMode(FuzzyMode.IGNORE_ALL);
        for (int x = 0; x < config.size(); ++x) {
            builder.add(config.getKey(x));
        }
        return builder.build();
    }

    private void updatePickupFilter() {
        this.pickupFilter = this.createFilter(this.pickupConfig);
        CompoundTag tag = (CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.PICKUP_CONFIG, (Object)new CompoundTag());
        this.pickupConfig.writeToChildTag(tag, "", (HolderLookup.Provider)this.ctHandler.player.registryAccess());
        this.getStack().set(AE2wtlibComponents.PICKUP_CONFIG, (Object)tag);
    }

    private void updateInsertFilter() {
        this.insertFilter = this.createFilter(this.insertConfig);
        CompoundTag tag = (CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.INSERT_CONFIG, (Object)new CompoundTag());
        this.insertConfig.writeToChildTag(tag, "", (HolderLookup.Provider)this.ctHandler.player.registryAccess());
        this.getStack().set(AE2wtlibComponents.INSERT_CONFIG, (Object)tag);
    }

    public IPartitionList getPickupFilter() {
        return this.pickupFilter;
    }

    public IncludeExclude getPickupMode() {
        return (IncludeExclude)this.getStack().getOrDefault(AE2wtlibComponents.PICKUP_MODE, (Object)IncludeExclude.BLACKLIST);
    }

    public void togglePickupMode() {
        this.getStack().set(AE2wtlibComponents.PICKUP_MODE, (Object)this.toggle((IncludeExclude)this.getStack().getOrDefault(AE2wtlibComponents.PICKUP_MODE, (Object)IncludeExclude.BLACKLIST)));
    }

    public IPartitionList getInsertFilter() {
        return this.insertFilter;
    }

    public IncludeExclude getInsertMode() {
        return (IncludeExclude)this.getStack().getOrDefault(AE2wtlibComponents.INSERT_MODE, (Object)IncludeExclude.BLACKLIST);
    }

    public void toggleInsertMode() {
        this.getStack().set(AE2wtlibComponents.INSERT_MODE, (Object)this.toggle((IncludeExclude)this.getStack().getOrDefault(AE2wtlibComponents.INSERT_MODE, (Object)IncludeExclude.BLACKLIST)));
    }

    private ItemStack getStack() {
        return this.ctHandler.getCraftingTerminal();
    }

    public IncludeExclude toggle(IncludeExclude includeExclude) {
        return switch (includeExclude) {
            default -> throw new MatchException(null, null);
            case IncludeExclude.WHITELIST -> IncludeExclude.BLACKLIST;
            case IncludeExclude.BLACKLIST -> IncludeExclude.WHITELIST;
        };
    }

    public void copyUp() {
        this.pickupConfig.readFromChildTag((CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.INSERT_CONFIG, (Object)new CompoundTag()), "", (HolderLookup.Provider)this.ctHandler.player.registryAccess());
    }

    public void copyDown() {
        this.insertConfig.readFromChildTag((CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.PICKUP_CONFIG, (Object)new CompoundTag()), "", (HolderLookup.Provider)this.ctHandler.player.registryAccess());
    }

    public void switchInsertPickup() {
        CompoundTag pickupTag = (CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.PICKUP_CONFIG, (Object)new CompoundTag());
        CompoundTag insertTag = (CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.INSERT_CONFIG, (Object)new CompoundTag());
        this.pickupConfig.writeToChildTag(pickupTag, "", (HolderLookup.Provider)this.ctHandler.player.registryAccess());
        this.getStack().set(AE2wtlibComponents.INSERT_CONFIG, (Object)pickupTag);
        this.insertConfig.writeToChildTag(insertTag, "", (HolderLookup.Provider)this.ctHandler.player.registryAccess());
        this.getStack().set(AE2wtlibComponents.PICKUP_CONFIG, (Object)insertTag);
        this.pickupConfig.readFromChildTag((CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.PICKUP_CONFIG, (Object)new CompoundTag()), "", (HolderLookup.Provider)this.ctHandler.player.registryAccess());
        this.insertConfig.readFromChildTag((CompoundTag)this.getStack().getOrDefault(AE2wtlibComponents.INSERT_CONFIG, (Object)new CompoundTag()), "", (HolderLookup.Provider)this.ctHandler.player.registryAccess());
    }
}

