/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators.TYGLeavesVineDecorator;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators.TYGTreeDecoratorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class TYGTrunkVineDecorator
extends TreeDecorator {
    public static final MapCodec<TYGTrunkVineDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuiltInRegistries.BLOCK.byNameCodec().flatXmap(TYGLeavesVineDecorator.mustExtendVineBlock(), TYGLeavesVineDecorator.mustExtendVineBlock()).fieldOf("vine_block").forGetter(bygLeavesVineDecorator -> bygLeavesVineDecorator.vineBlock), (App)Codec.FLOAT.fieldOf("probability").forGetter(bygLeavesVineDecorator -> Float.valueOf(bygLeavesVineDecorator.probability))).apply((Applicative)builder, (vineBlock, probability) -> new TYGTrunkVineDecorator((VineBlock)vineBlock, probability.floatValue())));
    private final VineBlock vineBlock;
    private final float probability;

    public TYGTrunkVineDecorator(VineBlock vineBlock, float probability) {
        this.vineBlock = vineBlock;
        this.probability = probability;
    }

    @NotNull
    protected TreeDecoratorType<?> type() {
        return TYGTreeDecoratorTypes.TRUNK_VINE.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        context.logs().forEach(pos -> {
            BlockPos pos1;
            if (randomSource.nextFloat() <= this.probability && context.isAir(pos1 = pos.west())) {
                this.placeVine(context, pos1, VineBlock.EAST);
            }
            if (randomSource.nextFloat() <= this.probability && context.isAir(pos1 = pos.east())) {
                this.placeVine(context, pos1, VineBlock.WEST);
            }
            if (randomSource.nextFloat() <= this.probability && context.isAir(pos1 = pos.north())) {
                this.placeVine(context, pos1, VineBlock.SOUTH);
            }
            if (randomSource.nextFloat() <= this.probability && context.isAir(pos1 = pos.south())) {
                this.placeVine(context, pos1, VineBlock.NORTH);
            }
        });
    }

    public void placeVine(TreeDecorator.Context context, BlockPos blockPos, BooleanProperty booleanProperty) {
        context.setBlock(blockPos, (BlockState)this.vineBlock.defaultBlockState().setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(true)));
    }
}

