/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs;

import com.almostreliable.ponderjs.PonderJS;
import com.almostreliable.ponderjs.mixin.PonderTagRegistryAccessor;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.ponder.api.registration.MultiTagBuilder;
import net.createmod.ponder.api.registration.PonderTagRegistrationHelper;
import net.createmod.ponder.api.registration.TagBuilder;
import net.createmod.ponder.foundation.PonderTag;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PonderItemTagEventJS
implements KubeEvent {
    private final PonderTagRegistrationHelper<ResourceLocation> helper;

    public PonderItemTagEventJS(PonderTagRegistrationHelper<ResourceLocation> helper) {
        this.helper = helper;
    }

    public void createTag(String id, Consumer<Builder> onCreate) {
        ResourceLocation idWithNameSpace = PonderJS.appendKubeToId(id);
        PonderJS.NAMESPACES.add(idWithNameSpace.getNamespace());
        Builder builder = new Builder(idWithNameSpace);
        onCreate.accept(builder);
        builder.fin(this.helper);
    }

    public void createTag(String id, Item displayItem, String title, String description, @Nullable Ingredient ingredient) {
        this.createTag(id, builder -> {
            builder.icon(displayItem);
            builder.title(title);
            builder.description(description);
            if (ingredient != null) {
                builder.items(ingredient);
            }
        });
    }

    public void createTag(String id, Item displayItem, String title, String description) {
        this.createTag(id, displayItem, title, description, null);
    }

    public void add(PonderTag tag, Ingredient ingredient) {
        if (ingredient.isEmpty()) {
            return;
        }
        MultiTagBuilder.Tag tagBuilder = this.helper.addToTag(tag.getId());
        for (ItemStack item : ingredient.getItems()) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
            tagBuilder.add((Object)id);
        }
    }

    public void removeTag(PonderTag ... tagsToRemove) {
        if (tagsToRemove.length == 0) {
            return;
        }
        PonderTagRegistryAccessor reg = PonderJS.getTagRegistryAccessor();
        for (PonderTag tag : tagsToRemove) {
            if (tag.equals((Object)reg.getMissing())) continue;
            reg.getRegisteredTags().remove(tag.getId());
            reg.getListedTags().remove(tag);
            this.remove(tag, PonderJS.getTagRegistry().getItems(tag));
        }
    }

    public void remove(PonderTag tag, Ingredient ingredient) {
        if (ingredient.isEmpty()) {
            return;
        }
        Set<ResourceLocation> ids = Arrays.stream(ingredient.getItems()).map(ItemStack::getItem).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).collect(Collectors.toSet());
        this.remove(tag, ids);
    }

    private void remove(PonderTag tag, Set<ResourceLocation> items) {
        PonderTagRegistryAccessor reg = PonderJS.getTagRegistryAccessor();
        for (ResourceLocation item : items) {
            if (!reg.getComponentTagMap().get((Object)item).remove(tag.getId())) continue;
            ConsoleJS.CLIENT.info((Object)("Removed ponder tag " + String.valueOf(tag.getId()) + " from item " + String.valueOf(item)));
        }
    }

    public static class Builder {
        private final LinkedHashSet<ResourceLocation> itemIds = new LinkedHashSet();
        private final ResourceLocation id;
        @Nullable
        private String title;
        @Nullable
        private String description;
        private Item itemIcon = Items.BARRIER;
        private boolean noIndex = false;
        private boolean addItemIconToItems = false;

        private Builder(ResourceLocation id) {
            this.id = id;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder icon(Item item) {
            this.itemIcon = item;
            return this;
        }

        public Builder noIndex() {
            this.noIndex = true;
            return this;
        }

        public Builder addIconToItems() {
            this.addItemIconToItems = true;
            return this;
        }

        public Builder items(Ingredient ingredient) {
            for (ItemStack item : ingredient.getItems()) {
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
                this.itemIds.add(itemId);
            }
            return this;
        }

        private void fin(PonderTagRegistrationHelper<ResourceLocation> helper) {
            Preconditions.checkNotNull((Object)this.title, (Object)("Title cannot be null for tag " + String.valueOf(this.id)));
            Preconditions.checkNotNull((Object)this.description, (Object)("Description cannot be null for tag " + String.valueOf(this.id)));
            TagBuilder tagBuilder = helper.registerTag(this.id).title(this.title).description(this.description);
            if (!this.noIndex) {
                tagBuilder.addToIndex();
            }
            tagBuilder.item((ItemLike)this.itemIcon, true, this.addItemIconToItems);
            tagBuilder.register();
            for (ResourceLocation itemId : this.itemIds) {
                helper.addTagToComponent((Object)itemId, this.id);
            }
        }
    }
}

