/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.extension;

import com.almostreliable.ponderjs.api.CustomPonderSceneElement;
import com.almostreliable.ponderjs.util.BlockStateFunction;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.function.Consumer;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.EntityElement;
import net.createmod.ponder.api.element.PonderElement;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.PonderSceneBuilder;
import net.createmod.ponder.foundation.instruction.FadeInOutInstruction;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@RemapPrefixForJS(value="ponderjs$")
public interface WorldInstructionExtension {
    @HideFromJS
    public PonderSceneBuilder ponderjs$builder();

    default public CustomPonderSceneElement ponderjs$addElement(int ticks) {
        final CustomPonderSceneElement element = new CustomPonderSceneElement();
        element.setVisible(false);
        this.ponderjs$builder().addInstruction((PonderInstruction)new FadeInOutInstruction(this, ticks){

            protected void show(PonderScene scene) {
                scene.addElement((PonderElement)element);
                element.setVisible(true);
            }

            protected void hide(PonderScene scene) {
                element.setVisible(false);
            }

            protected void applyFade(PonderScene scene, float fade) {
                element.setFade(fade);
            }
        });
        return element;
    }

    default public CustomPonderSceneElement ponderjs$addElement() {
        CustomPonderSceneElement element = new CustomPonderSceneElement();
        this.ponderjs$builder().addInstruction(ponderScene -> {
            ponderScene.addElement((PonderElement)element);
            element.setVisible(true);
        });
        return element;
    }

    default public ElementLink<EntityElement> ponderjs$createEntity(EntityType<?> entityType, Vec3 position, Consumer<Entity> consumer) {
        return this.ponderjs$builder().world().createEntity(level -> {
            Entity entity = entityType.create(level);
            if (entity == null) {
                throw new IllegalArgumentException("Could not create entity of type " + String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType)));
            }
            entity.setPosRaw(position.x, position.y, position.z);
            entity.setOldPosAndRot();
            entity.lookAt(EntityAnchorArgument.Anchor.FEET, position.add(0.0, 0.0, -1.0));
            consumer.accept(entity);
            return entity;
        });
    }

    default public ElementLink<EntityElement> ponderjs$createEntity(EntityType<?> entityType, Vec3 position) {
        return this.ponderjs$createEntity(entityType, position, entity -> {});
    }

    default public void ponderjs$modifyBlocks(Selection pos, BlockStateFunction function) {
        this.ponderjs$modifyBlocks(pos, true, function);
    }

    default public void ponderjs$modifyBlocks(Selection selection, boolean spawnParticles, BlockStateFunction function) {
        this.ponderjs$builder().world().modifyBlocks(selection, BlockStateFunction.from(function), spawnParticles);
    }

    default public void ponderjs$modifyBlocks(Selection selection, BlockStateFunction function, boolean spawnParticles) {
        this.ponderjs$builder().world().modifyBlocks(selection, BlockStateFunction.from(function), spawnParticles);
    }

    default public void ponderjs$modifyBlock(BlockPos pos, BlockStateFunction function, boolean spawnParticles) {
        this.ponderjs$builder().world().modifyBlock(pos, BlockStateFunction.from(function), spawnParticles);
    }

    default public void ponderjs$setBlocks(Selection selection, BlockState blockState) {
        this.ponderjs$setBlocks(selection, true, blockState);
    }

    default public void ponderjs$setBlocks(Selection selection, boolean spawnParticles, BlockState blockState) {
        this.ponderjs$builder().world().setBlocks(selection, blockState, spawnParticles);
    }

    default public void ponderjs$modifyBlockEntityNBT(Selection selection, Consumer<CompoundTag> consumer) {
        this.ponderjs$modifyBlockEntityNBT(selection, false, consumer);
    }

    default public void ponderjs$modifyBlockEntityNBT(Selection selection, boolean reDrawBlocks, Consumer<CompoundTag> consumer) {
        this.ponderjs$builder().world().modifyBlockEntityNBT(selection, BlockEntity.class, consumer, reDrawBlocks);
    }

    default public void ponderjs$removeEntity(ElementLink<EntityElement> link) {
        this.ponderjs$builder().addInstruction(scene -> {
            EntityElement resolve = (EntityElement)scene.resolve(link);
            if (resolve != null) {
                resolve.ifPresent(Entity::discard);
            }
        });
    }
}

