/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;

public class Configurations {
    public static final Configurations INSTANCE = new Configurations();
    private final ModConfigSpec configSpec;
    public final ModConfigSpec.BooleanValue disableCTM;
    public final ModConfigSpec.BooleanValue connectInsideCTM;

    public static void register(ModContainer modContainer, IEventBus modBus) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configurations.INSTANCE.configSpec, "ctm.toml");
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modBus.addListener(ModConfigEvent.Reloading.class, event -> {
            if (event.getConfig().getModId().equals("ctm")) {
                AbstractCTMBakedModel.invalidateCaches();
                RenderSystem.recordRenderCall(() -> Minecraft.getInstance().levelRenderer.allChanged());
            }
        });
    }

    private Configurations() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.disableCTM = builder.translation("configuration.ctm.disable").comment("Disable connected textures entirely").define("disableCTM", false);
        this.connectInsideCTM = builder.translation("configuration.ctm.connect_inside").comment("Choose whether the inside corner is disconnected on a CTM block - https://imgur.com/eUywLZ4").define("connectInsideCTM", false);
        this.configSpec = builder.build();
    }

    public static boolean isDisabled() {
        return (Boolean)Configurations.INSTANCE.disableCTM.get();
    }

    public static boolean connectInsideCTM() {
        if (Configurations.INSTANCE.configSpec.isLoaded()) {
            return (Boolean)Configurations.INSTANCE.disableCTM.get();
        }
        return (Boolean)Configurations.INSTANCE.disableCTM.getDefault();
    }
}

