/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigType;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigSpec {
    private static final Map<ResourceLocation, ConfigSpec> CONFIG_STORAGE = new ConcurrentHashMap<ResourceLocation, ConfigSpec>();
    private final ResourceLocation configId;
    private final String fileName;
    private final Component readableName;
    private final Path filePath;
    private final ConfigType type;
    @Nullable
    private final Runnable changeCallback;

    public static void addTrackedSpec(ConfigSpec spec) {
        ConfigSpec old = CONFIG_STORAGE.put(spec.getId(), spec);
        if (old != null) {
            throw new IllegalStateException("Duplicate config type for with id " + String.valueOf(spec.getId()));
        }
    }

    public static Collection<ConfigSpec> getTrackedSpecs() {
        return CONFIG_STORAGE.values();
    }

    @Nullable
    public static ConfigSpec getConfigSpec(ResourceLocation configId) {
        return CONFIG_STORAGE.get(configId);
    }

    protected ConfigSpec(ResourceLocation id, String fileExtension, Path configDirectory, ConfigType type, @Nullable Runnable changeCallback) {
        this.configId = id;
        this.fileName = id.getNamespace() + "-" + id.getPath() + "." + fileExtension;
        this.filePath = configDirectory.resolve(this.fileName);
        this.type = type;
        this.changeCallback = changeCallback;
        this.readableName = Component.literal((String)ConfigSpec.getReadableName(id.toDebugFileName() + "_configs"));
        ConfigSpec.addTrackedSpec(this);
    }

    public Component getReadableName() {
        return this.readableName;
    }

    protected void onRefresh() {
        if (this.changeCallback != null) {
            this.changeCallback.run();
        }
    }

    public boolean isLoaded() {
        return true;
    }

    public abstract void forceLoad();

    public ConfigType getConfigType() {
        return this.type;
    }

    public String getModId() {
        return this.configId.getNamespace();
    }

    public ResourceLocation getId() {
        return this.configId;
    }

    public boolean isSynced() {
        return this.type.isSynced();
    }

    public String getFileName() {
        return this.fileName;
    }

    public Path getFullPath() {
        return this.filePath;
    }

    public abstract void loadFromBytes(InputStream var1);

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen makeScreen(Screen parent) {
        return this.makeScreen(parent, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public abstract Screen makeScreen(Screen var1, @Nullable ResourceLocation var2);

    public abstract boolean hasConfigScreen();

    public static String getReadableName(String name) {
        return Arrays.stream(name.replace(":", "_").split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ConfigSpec config, Exception cause) {
            super("Failed to load config file " + config.getFileName() + " of type " + String.valueOf((Object)config.getConfigType()) + " for mod " + config.getModId() + ". Try deleting it", cause);
        }
    }
}

