/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator;

import com.klikli_dev.theurgy.content.apparatus.salammoniacaccumulator.SalAmmoniacAccumulatorCachedCheck;
import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.AccumulationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerWithFluidRecipeInput;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SalAmmoniacAccumulatorCraftingBehaviour
extends CraftingBehaviour<ItemHandlerWithFluidRecipeInput, AccumulationRecipe, SalAmmoniacAccumulatorCachedCheck> {
    protected Supplier<IFluidHandler> waterTankSupplier;
    protected Supplier<IFluidHandler> outputTankSupplier;

    public SalAmmoniacAccumulatorCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<IFluidHandler> waterTankSupplier, Supplier<IFluidHandler> outputTankSupplier) {
        super(blockEntity, Lazy.of(() -> new ItemHandlerWithFluidRecipeInput((IItemHandlerModifiable)inputInventorySupplier.get(), (IFluidHandler)waterTankSupplier.get())), inputInventorySupplier, outputInventorySupplier, new SalAmmoniacAccumulatorCachedCheck((RecipeType<AccumulationRecipe>)((RecipeType)RecipeTypeRegistry.ACCUMULATION.get())));
        this.waterTankSupplier = waterTankSupplier;
        this.outputTankSupplier = outputTankSupplier;
    }

    @Override
    public boolean isIngredient(ItemStack stack) {
        return ((SalAmmoniacAccumulatorCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.getLevel()).isPresent();
    }

    @Override
    public boolean canProcess(FluidStack stack) {
        if (FluidStack.isSameFluidSameComponents((FluidStack)this.waterTankSupplier.get().getFluidInTank(0), (FluidStack)stack)) {
            return true;
        }
        return this.isIngredient(stack);
    }

    @Override
    public boolean isIngredient(FluidStack stack) {
        return ((SalAmmoniacAccumulatorCachedCheck)this.recipeCachedCheck).getRecipeFor(stack, this.blockEntity.getLevel()).isPresent();
    }

    @Override
    protected int getIngredientCount(RecipeHolder<AccumulationRecipe> recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(RecipeHolder<AccumulationRecipe> recipe) {
        return ((AccumulationRecipe)recipe.value()).getTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 100;
    }

    @Override
    public boolean canCraft(@Nullable RecipeHolder<AccumulationRecipe> pRecipe) {
        if (pRecipe == null) {
            return false;
        }
        FluidStack assembledStack = ((AccumulationRecipe)pRecipe.value()).assembleFluid((ItemHandlerWithFluidRecipeInput)this.recipeInputSupplier.get(), (HolderLookup.Provider)this.blockEntity.getLevel().registryAccess());
        if (assembledStack.isEmpty()) {
            return false;
        }
        IFluidHandler tank = this.outputTankSupplier.get();
        int fluidAccepted = tank.fill(assembledStack, IFluidHandler.FluidAction.SIMULATE);
        return fluidAccepted == assembledStack.getAmount();
    }

    @Override
    protected boolean craft(RecipeHolder<AccumulationRecipe> pRecipe) {
        FluidStack assembledFluid = ((AccumulationRecipe)pRecipe.value()).assembleFluid((ItemHandlerWithFluidRecipeInput)this.recipeInputSupplier.get(), (HolderLookup.Provider)this.blockEntity.getLevel().registryAccess());
        IFluidHandler outputFluidTank = this.outputTankSupplier.get();
        outputFluidTank.fill(assembledFluid, IFluidHandler.FluidAction.EXECUTE);
        if (((AccumulationRecipe)pRecipe.value()).hasSolute()) {
            ((IItemHandlerModifiable)this.inputInventorySupplier.get()).extractItem(0, this.getIngredientCount(pRecipe), false);
        }
        if (((AccumulationRecipe)pRecipe.value()).hasEvaporant()) {
            this.waterTankSupplier.get().drain(((AccumulationRecipe)pRecipe.value()).getEvaporantAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }
}

