/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.filter;

import com.klikli_dev.theurgy.content.behaviour.filter.Filter;
import com.klikli_dev.theurgy.content.behaviour.filter.FilterMode;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemAttribute;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class AttributeFilter
extends Filter {
    public FilterMode filterMode;
    public List<Pair<ItemAttribute, Boolean>> attributeTests;

    protected AttributeFilter(HolderLookup.Provider provider, ItemStack filter) {
        super(provider, filter);
    }

    @Override
    protected void initFromFilterItemStack(HolderLookup.Provider provider, ItemStack filterItemStack) {
        this.attributeTests = new ArrayList<Pair<ItemAttribute, Boolean>>();
        this.filterMode = (FilterMode)((Object)filterItemStack.getOrDefault(DataComponentRegistry.FILTER_MODE, (Object)FilterMode.ACCEPT_LIST_OR));
        CompoundTag tag = ((CustomData)filterItemStack.getOrDefault(DataComponentRegistry.FILTER_ATTRIBUTES, (Object)CustomData.EMPTY)).getUnsafe();
        ListTag attributes = tag.getList("MatchedAttributes", 10);
        for (Tag inbt : attributes) {
            CompoundTag compound = (CompoundTag)inbt;
            ItemAttribute attribute = ItemAttribute.of(provider, compound);
            if (attribute == null) continue;
            this.attributeTests.add((Pair<ItemAttribute, Boolean>)Pair.of((Object)attribute, (Object)compound.getBoolean("Inverted")));
        }
    }

    @Override
    public boolean test(Level level, ItemStack stack, boolean matchDataComponents) {
        if (this.attributeTests.isEmpty()) {
            return true;
        }
        block15: for (Pair<ItemAttribute, Boolean> test : this.attributeTests) {
            boolean matches;
            ItemAttribute attribute = (ItemAttribute)test.getFirst();
            boolean inverted = (Boolean)test.getSecond();
            boolean bl = matches = attribute.appliesTo(stack, level) != inverted;
            if (matches) {
                switch (this.filterMode) {
                    case DENY_LIST: {
                        return false;
                    }
                    case ACCEPT_LIST_AND: {
                        continue block15;
                    }
                    case ACCEPT_LIST_OR: {
                        return true;
                    }
                }
                continue;
            }
            switch (this.filterMode) {
                case DENY_LIST: {
                    continue block15;
                }
                case ACCEPT_LIST_AND: {
                    return false;
                }
                case ACCEPT_LIST_OR: {
                    continue block15;
                }
            }
        }
        switch (this.filterMode) {
            case DENY_LIST: {
                return true;
            }
            case ACCEPT_LIST_AND: {
                return true;
            }
            case ACCEPT_LIST_OR: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean test(Level level, FluidStack stack, boolean matchDataComponents) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.filterItemStack.isEmpty();
    }
}

