/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.filter.attribute;

import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ItemNameAttribute
implements ItemAttribute {
    public static final ItemAttribute DUMMY = new ItemNameAttribute("dummy");
    String itemName;

    public ItemNameAttribute(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.extractCustomName(itemStack).equals(this.itemName);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        String name = this.extractCustomName(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (name.length() > 0) {
            atts.add(new ItemNameAttribute(name));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        return "has_name";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.itemName};
    }

    @Override
    public void writeNBT(HolderLookup.Provider pRegistries, CompoundTag nbt) {
        nbt.putString("name", this.itemName);
    }

    @Override
    public ItemAttribute readNBT(HolderLookup.Provider pRegistries, CompoundTag nbt) {
        return new ItemNameAttribute(nbt.getString("name"));
    }

    private String extractCustomName(ItemStack stack) {
        Component name = (Component)stack.get(DataComponents.ITEM_NAME);
        return name == null ? "" : name.getString();
    }
}

