/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.logistics;

import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeMode;
import com.klikli_dev.theurgy.logistics.Logistics;
import com.klikli_dev.theurgy.logistics.LogisticsNetwork;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public abstract class InserterNodeBehaviour<T, C>
extends LeafNodeBehaviour<T, C> {
    protected List<BlockCapabilityCache<T, C>> targetCapabilities = new ArrayList<BlockCapabilityCache<T, C>>();

    public InserterNodeBehaviour(BlockEntity blockEntity, BlockCapability<T, C> capabilityType) {
        super(blockEntity, capabilityType);
    }

    @Override
    public LeafNodeMode mode() {
        return LeafNodeMode.INSERT;
    }

    @Override
    public void onLoad() {
        this.targetCapabilities = this.buildTargetCapabilities(this.targets());
        super.onLoad();
    }

    public List<BlockCapabilityCache<T, C>> buildTargetCapabilities(List<BlockPos> targets) {
        ServerLevel serverLevel = (ServerLevel)this.level();
        return targets.stream().map(target -> BlockCapabilityCache.create(this.capabilityType(), (ServerLevel)serverLevel, (BlockPos)target, this.getTargetContext((BlockPos)target), () -> !this.blockEntity.isRemoved(), () -> this.onCapabilityInvalidated((BlockPos)target, this, false))).toList();
    }

    public void onCapabilityInvalidated(BlockPos targetPos, InserterNodeBehaviour<T, C> leafNode, boolean forceSetRemoved) {
        ServerLevel serverLevel = (ServerLevel)this.level();
        boolean targetValid = serverLevel.isLoaded(targetPos) && serverLevel.getBlockEntity(targetPos) != null;
        GlobalPos targetGlobalPos = GlobalPos.of((ResourceKey)serverLevel.dimension(), (BlockPos)targetPos);
        LogisticsNetwork network = Logistics.get().getNetwork(this.globalPos());
        if (network != null) {
            BlockCapabilityCache capabilityCache;
            network.onInserterNodeTargetRemoved(targetGlobalPos, leafNode);
            if (targetValid && !forceSetRemoved && (capabilityCache = (BlockCapabilityCache)this.targetCapabilities.stream().filter((? super T cache) -> cache.pos().equals((Object)targetPos)).findFirst().orElse(null)) != null) {
                network.onInserterNodeTargetAdded(targetGlobalPos, capabilityCache, leafNode);
            }
        }
    }

    protected void notifyTargetCapabilityCacheCreated(BlockCapabilityCache<T, C> capability) {
        ServerLevel serverLevel = (ServerLevel)this.level();
        boolean targetValid = serverLevel.isLoaded(capability.pos()) && serverLevel.getBlockEntity(capability.pos()) != null;
        GlobalPos targetGlobalPos = GlobalPos.of((ResourceKey)serverLevel.dimension(), (BlockPos)capability.pos());
        LogisticsNetwork network = Logistics.get().getNetwork(this.globalPos());
        if (network != null && targetValid) {
            network.onInserterNodeTargetAdded(targetGlobalPos, capability, this);
        }
    }

    public List<BlockCapabilityCache<T, C>> availableTargetCapabilities() {
        return this.targetCapabilities.stream().filter((? super T cache) -> this.level().isLoaded(cache.pos()) && this.level().getCapability(this.capabilityType(), cache.pos(), cache.context()) != null).toList();
    }

    public List<BlockCapabilityCache<T, C>> allTargetCapabilities() {
        return this.targetCapabilities;
    }
}

