/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.entity;

import com.klikli_dev.theurgy.content.entity.ColoredProjectile;
import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.content.particle.glow.GlowParticleProvider;
import com.klikli_dev.theurgy.content.render.Color;
import com.klikli_dev.theurgy.registry.EntityDataSerializerRegistry;
import com.klikli_dev.theurgy.registry.EntityRegistry;
import com.klikli_dev.theurgy.registry.ParticleRegistry;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FollowProjectile
extends ColoredProjectile {
    public static final EntityDataAccessor<Vec3> TO = SynchedEntityData.defineId(FollowProjectile.class, EntityDataSerializerRegistry.VEC3_FLOAT.get());
    public static final EntityDataAccessor<Vec3> FROM = SynchedEntityData.defineId(FollowProjectile.class, EntityDataSerializerRegistry.VEC3_FLOAT.get());
    public static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(FollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> SPAWN_TOUCH = SynchedEntityData.defineId(FollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DESPAWN_DISTANCE = SynchedEntityData.defineId(FollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> ARRIVAL_DISTANCE = SynchedEntityData.defineId(FollowProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final int maxAge = 500;
    private int age;
    private long spawnTime = -1L;
    private Consumer<FollowProjectile> onArrival;

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, @Nullable Color finalColor, float size, float arrivalDistance, Consumer<FollowProjectile> onArrival) {
        this((EntityType<? extends FollowProjectile>)EntityRegistry.FOLLOW_PROJECTILE.get(), level);
        this.entityData.set(TO, (Object)to);
        this.entityData.set(FROM, (Object)from);
        this.setPos(from.x, from.y, from.z);
        this.entityData.set(COLOR, (Object)color.getRGB());
        this.entityData.set(FINAL_COLOR, (Object)(finalColor == null ? color.getRGB() : finalColor.getRGB()));
        this.entityData.set(SIZE, (Object)Float.valueOf(size));
        this.entityData.set(ARRIVAL_DISTANCE, (Object)Float.valueOf(arrivalDistance));
        double distance = from.distanceTo(to);
        this.onArrival = onArrival;
        this.setDespawnDistance((int)(distance + 10.0));
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, @Nullable Color finalColor, float size, Consumer<FollowProjectile> onArrival) {
        this(level, from, to, color, finalColor, size, 1.0f, onArrival);
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, int r, int g, int b, float size) {
        this(level, from, to, new Color(r, g, b), new Color(r, g, b), size, 1.0f, p -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, int r, int g, int b, float size, float arrivalDistance) {
        this(level, from, to, new Color(r, g, b), new Color(r, g, b), size, arrivalDistance, p -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, float size, Consumer<FollowProjectile> onArrival) {
        this(level, from, to, color, color, size, 1.0f, onArrival);
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, float size, float arrivalDistance, Consumer<FollowProjectile> onArrival) {
        this(level, from, to, color, color, size, arrivalDistance, onArrival);
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, float size) {
        this(level, from, to, color, size, p -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, float size, float arrivalDistance) {
        this(level, from, to, color, size, arrivalDistance, (FollowProjectile p) -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, Color finalColor, float size) {
        this(level, from, to, color, finalColor, size, 1.0f, p -> {});
    }

    public FollowProjectile(Level level, Vec3 from, Vec3 to, Color color, Color finalColor, float size, float arrivalDistance) {
        this(level, from, to, color, finalColor, size, arrivalDistance, p -> {});
    }

    public FollowProjectile(EntityType<? extends FollowProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public void setDespawnDistance(int distance) {
        this.getEntityData().set(DESPAWN_DISTANCE, (Object)distance);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TO, (Object)new Vec3(0.0, 0.0, 0.0));
        builder.define(FROM, (Object)new Vec3(0.0, 0.0, 0.0));
        builder.define(SIZE, (Object)Float.valueOf(0.0f));
        builder.define(SPAWN_TOUCH, (Object)this.defaultsBurst());
        builder.define(DESPAWN_DISTANCE, (Object)10);
        builder.define(ARRIVAL_DISTANCE, (Object)Float.valueOf(1.0f));
    }

    public boolean defaultsBurst() {
        return false;
    }

    public void tick() {
        block10: {
            block9: {
                super.tick();
                ++this.age;
                if (this.age > this.maxAge) break block9;
                long l = this.level().getGameTime() - this.spawnTime;
                Objects.requireNonNull(this);
                if (l <= 500L) break block10;
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Vec3 deltaMovement = this.getDeltaMovement();
        Vec3 to = (Vec3)this.entityData.get(TO);
        Vec3 from = (Vec3)this.entityData.get(FROM);
        double totalDist = from.distanceTo(to);
        double coveredDist = this.position().distanceTo(from);
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        double motionX = deltaMovement.x;
        double motionY = deltaMovement.y;
        double motionZ = deltaMovement.z;
        double maxMotion = Math.max(Math.abs(motionX), Math.max(Math.abs(motionY), Math.abs(motionZ)));
        double arrivalDistance = ((Float)this.entityData.get(ARRIVAL_DISTANCE)).floatValue();
        if (Math.sqrt(this.position().distanceToSqr(to)) < arrivalDistance || maxMotion >= arrivalDistance && maxMotion + Math.sqrt(this.position().distanceToSqr(to)) < arrivalDistance || this.age > 1000 || Math.sqrt(this.position().distanceToSqr(to)) > (double)((Integer)this.entityData.get(DESPAWN_DISTANCE)).intValue()) {
            if (this.level().isClientSide && ((Boolean)this.entityData.get(SPAWN_TOUCH)).booleanValue()) {
                ParticleRegistry.spawnTouch((ClientLevel)this.level(), this.getOnPos(), ParticleColor.fromInt(this.finalColor()));
            }
            this.onArrival.accept(this);
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (to.x() != 0.0 || to.y() != 0.0 || to.z() != 0.0) {
            double targetX = to.x();
            double targetY = to.y();
            double targetZ = to.z();
            Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.length();
            targetVector = targetVector.scale(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = 0.9 * ((3.0 - length) / 3.0);
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.x;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.y;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.z;
        }
        this.setPos(posX += motionX, posY += motionY, posZ += motionZ);
        this.setDeltaMovement(motionX, motionY, motionZ);
        float speed = 1.0f;
        this.setDeltaMovement(this.getDeltaMovement().scale((double)speed));
        if (this.level().isClientSide && this.age > 1) {
            int endColor;
            int particleAge = 50;
            double deltaX = this.getX() - this.xOld;
            double deltaY = this.getY() - this.yOld;
            double deltaZ = this.getZ() - this.zOld;
            float dist = (float)(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
            int startColor = this.color();
            int currentColor = startColor == (endColor = this.finalColor()) ? endColor : Color.mixColors(startColor, endColor, (float)(coveredDist / totalDist));
            for (double i = 0.0; i <= (double)dist; i += 1.0) {
                double coeff = i / (double)dist;
                this.level().addParticle(GlowParticleProvider.createOptions(ParticleColor.fromInt(currentColor), ((Float)this.entityData.get(SIZE)).floatValue(), 0.75f, particleAge), this.getX() + deltaX * coeff, this.getY() + deltaY * coeff, this.getZ() + deltaZ * coeff, (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)));
            }
        }
    }

    public void setRemoved(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.UNLOADED_TO_CHUNK) {
            reason = Entity.RemovalReason.DISCARDED;
        }
        super.setRemoved(reason);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(FROM, (Object)((Vec3)Vec3.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("from")).result().get()));
        this.entityData.set(TO, (Object)((Vec3)Vec3.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("to")).result().get()));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        Vec3.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)((Vec3)this.entityData.get(FROM))).result().ifPresent(e -> compound.put("from", e));
        Vec3.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)((Vec3)this.entityData.get(TO))).result().ifPresent(e -> compound.put("to", e));
    }

    public EntityType<?> getType() {
        return EntityRegistry.FOLLOW_PROJECTILE.get();
    }

    public boolean isNoGravity() {
        return true;
    }

    public Vec3 to() {
        return (Vec3)this.entityData.get(TO);
    }

    public Vec3 from() {
        return (Vec3)this.entityData.get(FROM);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.spawnTime = this.level().getGameTime();
    }
}

