/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.mercurialwand.mode;

import com.klikli_dev.theurgy.content.item.mercurialwand.mode.MercurialWandItemMode;
import com.klikli_dev.theurgy.content.item.mode.ItemModeRenderHandler;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class SelectFrequencyMode
extends MercurialWandItemMode {
    private final Lazy<ItemModeRenderHandler<SelectFrequencyMode>> renderHandler = Lazy.of(() -> new ItemModeRenderHandler<SelectFrequencyMode>(this));

    protected SelectFrequencyMode() {
    }

    @Override
    public String descriptionId() {
        return "item.mode.theurgy.mercurial_wand.select_frequency";
    }

    @Override
    public MutableComponent description(ItemStack pStack, @Nullable Level pLevel) {
        Integer frequency = (Integer)pStack.getOrDefault((DataComponentType)DataComponentRegistry.SELECTED_FREQUENCY.get(), (Object)0);
        return Component.translatable((String)this.descriptionId(), (Object[])new Object[]{Component.literal((String)frequency.toString()).withStyle(ChatFormatting.GREEN)});
    }

    @Override
    public ItemModeRenderHandler<?> renderHandler() {
        return (ItemModeRenderHandler)this.renderHandler.get();
    }

    @Override
    public boolean onLeftClickBlock(Level level, Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        return this.onLeftClick(level, player, hand);
    }

    @Override
    public void onLeftClickEmpty(Level level, Player player, InteractionHand hand) {
        this.onLeftClick(level, player, hand);
    }

    protected boolean onLeftClick(Level level, Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return false;
        }
        if (level.isClientSide) {
            return false;
        }
        this.changeFrequency(player.getMainHandItem(), -1);
        Integer newFrequency = (Integer)player.getMainHandItem().getOrDefault((DataComponentType)DataComponentRegistry.SELECTED_FREQUENCY.get(), (Object)0);
        player.displayClientMessage((Component)Component.translatable((String)"item.mode.theurgy.mercurial_wand.select_frequency", (Object[])new Object[]{Component.literal((String)String.valueOf(newFrequency)).withStyle(ChatFormatting.GREEN)}), true);
        return true;
    }

    protected void changeFrequency(ItemStack stack, int delta) {
        stack.update((DataComponentType)DataComponentRegistry.SELECTED_FREQUENCY.get(), (Object)0, frequency -> frequency + delta);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        this.changeFrequency(stack, 1);
        Integer newFrequency = (Integer)stack.getOrDefault((DataComponentType)DataComponentRegistry.SELECTED_FREQUENCY.get(), (Object)0);
        context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.mode.theurgy.mercurial_wand.select_frequency", (Object[])new Object[]{Component.literal((String)String.valueOf(newFrequency)).withStyle(ChatFormatting.GREEN)}), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pUsedHand != InteractionHand.MAIN_HAND) {
            return super.use(pLevel, pPlayer, pUsedHand);
        }
        if (pLevel.isClientSide) {
            return super.use(pLevel, pPlayer, pUsedHand);
        }
        this.changeFrequency(pPlayer.getMainHandItem(), 1);
        Integer newFrequency = (Integer)pPlayer.getMainHandItem().getOrDefault((DataComponentType)DataComponentRegistry.SELECTED_FREQUENCY.get(), (Object)0);
        pPlayer.displayClientMessage((Component)Component.translatable((String)"item.mode.theurgy.mercurial_wand.select_frequency", (Object[])new Object[]{Component.literal((String)String.valueOf(newFrequency)).withStyle(ChatFormatting.GREEN)}), true);
        return InteractionResultHolder.success((Object)pPlayer.getItemInHand(pUsedHand));
    }
}

