/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api.energy;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.config.MIServerConfig;
import aztech.modern_industrialization.config.MIStartupConfig;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public class EnergyApi {
    public static final BlockCapability<MIEnergyStorage, Direction> SIDED = BlockCapability.createSided((ResourceLocation)MI.id("sided_mi_energy_storage"), MIEnergyStorage.class);
    public static final ItemCapability<ILongEnergyStorage, Void> ITEM = ItemCapability.createVoid((ResourceLocation)MI.id("energy_storage"), ILongEnergyStorage.class);
    private static final ThreadLocal<Boolean> IN_COMPAT = ThreadLocal.withInitial(() -> false);
    public static final MIEnergyStorage CREATIVE = new MIEnergyStorage.NoInsert(){

        @Override
        public boolean canConnect(CableTier cableTier) {
            return true;
        }

        public long extract(long maxAmount, boolean simulate) {
            return maxAmount;
        }

        public boolean canExtract() {
            return true;
        }

        public long getAmount() {
            return Long.MAX_VALUE;
        }

        public long getCapacity() {
            return Long.MAX_VALUE;
        }
    };
    public static final MIEnergyStorage EMPTY = new EmptyStorage();

    @ApiStatus.Internal
    public static void init(RegisterCapabilitiesEvent event, Block[] allBlocks, Item[] allItems) {
        if (MIStartupConfig.INSTANCE.bidirectionalEnergyCompat.getAsBoolean()) {
            event.registerBlock(ILongEnergyStorage.BLOCK, (world, pos, state, blockEntity, context) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    WrappedMIStorage wrappedMIStorage = WrappedMIStorage.of((ILongEnergyStorage)world.getCapability(SIDED, pos, state, blockEntity, context));
                    return wrappedMIStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, allBlocks);
            event.registerBlock(SIDED, (world, pos, state, blockEntity, context) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    WrappedExternalStorage wrappedExternalStorage = WrappedExternalStorage.of((ILongEnergyStorage)world.getCapability(ILongEnergyStorage.BLOCK, pos, state, blockEntity, context));
                    return wrappedExternalStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, allBlocks);
            event.registerItem(ILongEnergyStorage.ITEM, (stack, ignored) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    WrappedMIStorage wrappedMIStorage = WrappedMIStorage.of((ILongEnergyStorage)stack.getCapability(ITEM));
                    return wrappedMIStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, (ItemLike[])allItems);
            event.registerItem(ITEM, (stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    WrappedExternalStorage wrappedExternalStorage = WrappedExternalStorage.of((ILongEnergyStorage)stack.getCapability(ILongEnergyStorage.ITEM));
                    return wrappedExternalStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, (ItemLike[])allItems);
        } else {
            event.registerBlock(SIDED, (world, pos, state, blockEntity, context) -> InsertOnlyExternalStorage.of((ILongEnergyStorage)world.getCapability(ILongEnergyStorage.BLOCK, pos, state, blockEntity, context)), allBlocks);
            event.registerItem(ITEM, (stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    InsertOnlyExternalStorage insertOnlyExternalStorage = InsertOnlyExternalStorage.of((ILongEnergyStorage)stack.getCapability(ILongEnergyStorage.ITEM));
                    return insertOnlyExternalStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, (ItemLike[])allItems);
            event.registerItem(ILongEnergyStorage.ITEM, (stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    ExtractOnlyMIStorage extractOnlyMIStorage = ExtractOnlyMIStorage.of((ILongEnergyStorage)stack.getCapability(ITEM));
                    return extractOnlyMIStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            }, (ItemLike[])allItems);
        }
    }

    private static long ratio() {
        return MIServerConfig.INSTANCE.forgeEnergyPerEu.getAsInt();
    }

    private static class ExtractOnlyMIStorage
    extends WrappedMIStorage {
        private static @Nullable ExtractOnlyMIStorage of(@Nullable ILongEnergyStorage miStorage) {
            return miStorage == null || !miStorage.canExtract() ? null : new ExtractOnlyMIStorage(miStorage);
        }

        private ExtractOnlyMIStorage(ILongEnergyStorage miStorage) {
            super(miStorage);
        }

        @Override
        public long receive(long maxReceive, boolean simulate) {
            return 0L;
        }

        @Override
        public boolean canReceive() {
            return false;
        }
    }

    private static class InsertOnlyExternalStorage
    extends WrappedExternalStorage {
        private static @Nullable InsertOnlyExternalStorage of(@Nullable ILongEnergyStorage externalStorage) {
            return externalStorage == null || !externalStorage.canReceive() ? null : new InsertOnlyExternalStorage(externalStorage);
        }

        private InsertOnlyExternalStorage(ILongEnergyStorage externalStorage) {
            super(externalStorage);
        }

        @Override
        public long extract(long maxExtract, boolean simulate) {
            return 0L;
        }

        @Override
        public boolean canExtract() {
            return false;
        }
    }

    private static class WrappedExternalStorage
    implements MIEnergyStorage {
        private final ILongEnergyStorage externalStorage;

        private static @Nullable WrappedExternalStorage of(@Nullable ILongEnergyStorage externalStorage) {
            return externalStorage == null ? null : new WrappedExternalStorage(externalStorage);
        }

        private WrappedExternalStorage(ILongEnergyStorage externalStorage) {
            this.externalStorage = externalStorage;
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return true;
        }

        public long receive(long maxReceive, boolean simulate) {
            long ratio = EnergyApi.ratio();
            maxReceive = Math.min(maxReceive, Long.MAX_VALUE / ratio);
            maxReceive *= ratio;
            if (ratio > 1L) {
                maxReceive = this.externalStorage.receive(maxReceive, true) / ratio * ratio;
            }
            return this.externalStorage.receive(maxReceive, simulate) / ratio;
        }

        public long extract(long maxExtract, boolean simulate) {
            long ratio = EnergyApi.ratio();
            maxExtract = Math.min(maxExtract, Long.MAX_VALUE / ratio);
            maxExtract *= ratio;
            if (ratio > 1L) {
                maxExtract = this.externalStorage.extract(maxExtract, true) / ratio * ratio;
            }
            return this.externalStorage.extract(maxExtract, simulate) / ratio;
        }

        public long getAmount() {
            return this.externalStorage.getAmount() / EnergyApi.ratio();
        }

        public long getCapacity() {
            return this.externalStorage.getCapacity() / EnergyApi.ratio();
        }

        public boolean canExtract() {
            return this.externalStorage.canExtract();
        }

        public boolean canReceive() {
            return this.externalStorage.canReceive();
        }
    }

    private static class WrappedMIStorage
    implements ILongEnergyStorage {
        private final ILongEnergyStorage miStorage;

        private static @Nullable WrappedMIStorage of(@Nullable ILongEnergyStorage miStorage) {
            return miStorage == null ? null : new WrappedMIStorage(miStorage);
        }

        private WrappedMIStorage(ILongEnergyStorage miStorage) {
            this.miStorage = miStorage;
        }

        public long receive(long maxReceive, boolean simulate) {
            long ratio = EnergyApi.ratio();
            return this.miStorage.receive(maxReceive / ratio, simulate) * ratio;
        }

        public long extract(long maxExtract, boolean simulate) {
            long ratio = EnergyApi.ratio();
            return this.miStorage.extract(maxExtract / ratio, simulate) * ratio;
        }

        public long getAmount() {
            return this.miStorage.getAmount() * EnergyApi.ratio();
        }

        public long getCapacity() {
            return this.miStorage.getCapacity() * EnergyApi.ratio();
        }

        public boolean canExtract() {
            return this.miStorage.canExtract();
        }

        public boolean canReceive() {
            return this.miStorage.canReceive();
        }
    }

    private static class EmptyStorage
    implements MIEnergyStorage.NoInsert,
    MIEnergyStorage.NoExtract {
        private EmptyStorage() {
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return false;
        }

        public long getAmount() {
            return 0L;
        }

        public long getCapacity() {
            return 0L;
        }
    }
}

