/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines;

import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.guicomponents.AutoExtractClient;
import aztech.modern_industrialization.client.machines.guicomponents.CraftingMultiblockGuiClient;
import aztech.modern_industrialization.client.machines.guicomponents.EnergyBarClient;
import aztech.modern_industrialization.client.machines.guicomponents.GeneratorMultiblockGuiClient;
import aztech.modern_industrialization.client.machines.guicomponents.GunpowderOverclockGuiClient;
import aztech.modern_industrialization.client.machines.guicomponents.LargeTankFluidDisplayClient;
import aztech.modern_industrialization.client.machines.guicomponents.NuclearReactorGuiClient;
import aztech.modern_industrialization.client.machines.guicomponents.ProgressBarClient;
import aztech.modern_industrialization.client.machines.guicomponents.RecipeEfficiencyBarClient;
import aztech.modern_industrialization.client.machines.guicomponents.ReiSlotLockingClient;
import aztech.modern_industrialization.client.machines.guicomponents.ShapeSelectionClient;
import aztech.modern_industrialization.client.machines.guicomponents.SlotPanelClient;
import aztech.modern_industrialization.client.machines.guicomponents.TemperatureBarClient;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.guicomponents.CraftingMultiblockGui;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.GeneratorMultiblockGui;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGui;
import aztech.modern_industrialization.machines.guicomponents.LargeTankFluidDisplay;
import aztech.modern_industrialization.machines.guicomponents.NuclearReactorGui;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBar;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class GuiComponentsClient {
    private static final Map<ResourceLocation, Registration<?, ?>> components = new HashMap();

    public static Registration<?, ?> get(ResourceLocation id) {
        Registration<?, ?> registration = components.get(id);
        if (registration == null) {
            throw new IllegalArgumentException("Unknown GUI component ID: " + String.valueOf(id));
        }
        return registration;
    }

    public static <P, D> void register(GuiComponentServer.Type<P, D> type, BiFunction<P, D, GuiComponentClient<P, D>> clientFactory) {
        if (components.put(type.id(), new Registration<P, D>(type, clientFactory)) != null) {
            throw new RuntimeException("Duplicate registration of component identifier.");
        }
    }

    static {
        GuiComponentsClient.register(AutoExtract.TYPE, AutoExtractClient::new);
        GuiComponentsClient.register(CraftingMultiblockGui.TYPE, CraftingMultiblockGuiClient::new);
        GuiComponentsClient.register(EnergyBar.TYPE, EnergyBarClient::new);
        GuiComponentsClient.register(LargeTankFluidDisplay.TYPE, LargeTankFluidDisplayClient::new);
        GuiComponentsClient.register(GeneratorMultiblockGui.TYPE, GeneratorMultiblockGuiClient::new);
        GuiComponentsClient.register(GunpowderOverclockGui.TYPE, GunpowderOverclockGuiClient::new);
        GuiComponentsClient.register(NuclearReactorGui.TYPE, NuclearReactorGuiClient::new);
        GuiComponentsClient.register(ProgressBar.TYPE, ProgressBarClient::new);
        GuiComponentsClient.register(RecipeEfficiencyBar.TYPE, RecipeEfficiencyBarClient::new);
        GuiComponentsClient.register(ReiSlotLocking.TYPE, ReiSlotLockingClient::new);
        GuiComponentsClient.register(ShapeSelection.TYPE, ShapeSelectionClient::new);
        GuiComponentsClient.register(SlotPanel.TYPE, SlotPanelClient::new);
        GuiComponentsClient.register(TemperatureBar.TYPE, TemperatureBarClient::new);
    }

    public record Registration<P, D>(GuiComponentServer.Type<P, D> type, BiFunction<P, D, GuiComponentClient<P, D>> clientFactory) {
        public GuiComponentClient<P, D> readNewComponent(RegistryFriendlyByteBuf buf) {
            Object params = this.type.paramsCodec().decode((Object)buf);
            Object data = this.type.dataCodec().decode((Object)buf);
            return this.clientFactory.apply(params, data);
        }
    }
}

