/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.network.machines.SetAutoExtractPacket;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.MutableComponent;

public class AutoExtractClient
extends GuiComponentClient<AutoExtract.Params, AutoExtract.Data> {
    public AutoExtractClient(AutoExtract.Params params, AutoExtract.Data data) {
        super(params, data);
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    private class Renderer
    implements ClientComponentRenderer {
        private Renderer() {
        }

        @Override
        public void addButtons(ClientComponentRenderer.ButtonContainer container) {
            if (((AutoExtract.Params)AutoExtractClient.this.params).hasExtractFluids()) {
                this.addExtractButton(container, false);
            }
            if (((AutoExtract.Params)AutoExtractClient.this.params).hasExtractItems()) {
                this.addExtractButton(container, true);
            }
        }

        private void addExtractButton(ClientComponentRenderer.ButtonContainer container, boolean isItem) {
            int u = isItem ? 20 : 0;
            AutoExtract.Display display = ((AutoExtract.Params)AutoExtractClient.this.params).display();
            container.addButton(u, syncId -> {
                boolean newExtract;
                if (isItem) {
                    newExtract = !((AutoExtract.Data)AutoExtractClient.this.data).extractItems();
                    AutoExtractClient.this.data = new AutoExtract.Data(newExtract, ((AutoExtract.Data)AutoExtractClient.this.data).extractFluids());
                } else {
                    newExtract = !((AutoExtract.Data)AutoExtractClient.this.data).extractFluids();
                    AutoExtractClient.this.data = new AutoExtract.Data(((AutoExtract.Data)AutoExtractClient.this.data).extractItems(), newExtract);
                }
                new SetAutoExtractPacket((int)syncId, isItem, newExtract).sendToServer();
            }, () -> {
                ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
                if (isItem ? ((AutoExtract.Data)AutoExtractClient.this.data).extractItems() : ((AutoExtract.Data)AutoExtractClient.this.data).extractFluids()) {
                    if (isItem) {
                        if (display != AutoExtract.Display.EXTRACT) {
                            lines.add(MIText.ItemAutoInsertOn.text());
                        }
                        if (display != AutoExtract.Display.INSERT) {
                            lines.add(MIText.ItemAutoExtractOn.text());
                        }
                    } else {
                        if (display != AutoExtract.Display.EXTRACT) {
                            lines.add(MIText.FluidAutoInsertOn.text());
                        }
                        if (display != AutoExtract.Display.INSERT) {
                            lines.add(MIText.FluidAutoExtractOn.text());
                        }
                    }
                    lines.add(MIText.ClickToDisable.text().setStyle(TextHelper.GRAY_TEXT));
                } else {
                    if (isItem) {
                        if (display != AutoExtract.Display.EXTRACT) {
                            lines.add(MIText.ItemAutoInsertOff.text());
                        }
                        if (display != AutoExtract.Display.INSERT) {
                            lines.add(MIText.ItemAutoExtractOff.text());
                        }
                    } else {
                        if (display != AutoExtract.Display.EXTRACT) {
                            lines.add(MIText.FluidAutoInsertOff.text());
                        }
                        if (display != AutoExtract.Display.INSERT) {
                            lines.add(MIText.FluidAutoExtractOff.text());
                        }
                    }
                    lines.add(MIText.ClickToEnable.text().setStyle(TextHelper.GRAY_TEXT));
                }
                return lines;
            }, () -> isItem ? ((AutoExtract.Data)AutoExtractClient.this.data).extractItems() : ((AutoExtract.Data)AutoExtractClient.this.data).extractFluids());
        }

        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
        }
    }
}

