/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.network.machines.ChangeShapePacket;
import aztech.modern_industrialization.util.Rectangle;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ShapeSelectionClient
extends GuiComponentClient<List<ShapeSelection.LineInfo>, List<Integer>> {
    private Renderer renderer;

    public ShapeSelectionClient(List<ShapeSelection.LineInfo> params, List<Integer> data) {
        super(params, data);
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        int maxWidth = 1;
        for (ShapeSelection.LineInfo line : (List)this.params) {
            for (Component tooltip : line.translations()) {
                maxWidth = Math.max(maxWidth, Minecraft.getInstance().font.width((FormattedText)tooltip));
            }
        }
        this.renderer = new Renderer(maxWidth);
        return this.renderer;
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    List<Integer> getData() {
        return (List)this.data;
    }

    class Renderer
    implements ClientComponentRenderer {
        boolean isPanelOpen = false;
        private final int btnSize = 12;
        private final int borderSize = 3;
        private final int outerPadding = 5;
        private final int innerPadding = 5;
        private final int textMaxWidth;
        private final int panelWidth;

        private Renderer(int textMaxWidth) {
            this.textMaxWidth = textMaxWidth;
            this.panelWidth = 25 + textMaxWidth + 5 + 12 + 5;
        }

        private static int getVerticalPos(int lineId) {
            return 46 + 16 * lineId;
        }

        @Override
        public void addButtons(ClientComponentRenderer.ButtonContainer container) {
            for (int i = 0; i < ((List)ShapeSelectionClient.this.params).size(); ++i) {
                int iCopy = i;
                ShapeSelection.LineInfo line = (ShapeSelection.LineInfo)((List)ShapeSelectionClient.this.params).get(i);
                int baseU = line.useArrows() ? 174 : 150;
                int v = 58;
                container.addButton(-this.panelWidth + 3 + 5, Renderer.getVerticalPos(i), 12, 12, syncId -> new ChangeShapePacket((int)syncId, iCopy, true).sendToServer(), List::of, (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                    if ((Integer)((List)ShapeSelectionClient.this.data).get(iCopy) == 0) {
                        screen.blitButtonNoHighlight(button, guiGraphics, baseU, v + 12);
                    } else {
                        screen.blitButtonSmall(button, guiGraphics, baseU, v);
                    }
                }, () -> this.isPanelOpen);
                container.addButton(-17, Renderer.getVerticalPos(i), 12, 12, syncId -> new ChangeShapePacket((int)syncId, iCopy, false).sendToServer(), List::of, (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                    if ((Integer)((List)ShapeSelectionClient.this.data).get(iCopy) == line.numValues() - 1) {
                        screen.blitButtonNoHighlight(button, guiGraphics, baseU + 12, v + 12);
                    } else {
                        screen.blitButtonSmall(button, guiGraphics, baseU + 12, v);
                    }
                }, () -> this.isPanelOpen);
            }
            container.addButton(-24, 17, 20, 20, syncId -> {
                this.isPanelOpen = !this.isPanelOpen;
            }, () -> List.of(MIText.ShapeSelectionTitle.text(), MIText.ShapeSelectionDescription.text().setStyle(TextHelper.GRAY_TEXT)), (screen, button, guiGraphics, mouseX, mouseY, delta) -> screen.blitButton(button, guiGraphics, 138, 38));
        }

        @Override
        public void renderBackground(GuiGraphics guiGraphics, int leftPos, int topPos) {
            Rectangle box = this.getBox(leftPos, topPos);
            guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y(), 0, 0, box.w(), box.h() - 4);
            guiGraphics.blit(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, 0, 252, box.w(), 4);
            if (this.isPanelOpen) {
                RenderSystem.disableDepthTest();
                for (int i = 0; i < ((List)ShapeSelectionClient.this.params).size(); ++i) {
                    ShapeSelection.LineInfo line = (ShapeSelection.LineInfo)((List)ShapeSelectionClient.this.params).get(i);
                    Component tooltip = line.translations().get((Integer)((List)ShapeSelectionClient.this.data).get(i));
                    int width = Minecraft.getInstance().font.width((FormattedText)tooltip);
                    guiGraphics.drawString(Minecraft.getInstance().font, tooltip, box.x() + 3 + 5 + 12 + 5 + (this.textMaxWidth - width) / 2, topPos + Renderer.getVerticalPos(i) + 2, 0x404040, false);
                }
                RenderSystem.enableDepthTest();
            }
        }

        public Rectangle getBox(int leftPos, int topPos) {
            if (this.isPanelOpen) {
                int topOffset = 10;
                return new Rectangle(leftPos - this.panelWidth, topPos + topOffset, this.panelWidth, Renderer.getVerticalPos(((List)ShapeSelectionClient.this.params).size() - 1) - topOffset + 12 + 5 + 3);
            }
            return new Rectangle(leftPos - 31, topPos + 10, 31, 34);
        }

        @Override
        public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
            rectangles.add(this.getBox(leftPos, topPos));
        }
    }
}

