/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.textures;

import aztech.modern_industrialization.client.textures.IORunnable;
import aztech.modern_industrialization.textures.MCMetaInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class TextureManager {
    private final ResourceProvider rm;
    private final BiConsumer<NativeImage, String> textureWriter;
    private final BiConsumer<JsonElement, String> mcMetaWriter;
    private final Queue<IORunnable> endRunnables = new ConcurrentLinkedQueue<IORunnable>();
    private final Set<String> generatedTextures = ConcurrentHashMap.newKeySet();
    private final Gson GSON = new Gson();

    public TextureManager(ResourceProvider rm, BiConsumer<NativeImage, String> textureWriter, BiConsumer<JsonElement, String> mcMetaWriter) {
        this.rm = rm;
        this.textureWriter = textureWriter;
        this.mcMetaWriter = mcMetaWriter;
    }

    public boolean hasAsset(String asset) {
        return this.rm.getResource(ResourceLocation.parse((String)asset)).isPresent();
    }

    public NativeImage getAssetAsTexture(String textureId) throws IOException {
        Optional resource = this.rm.getResource(ResourceLocation.parse((String)textureId));
        if (resource.isPresent()) {
            try (InputStream stream = ((Resource)resource.get()).open();){
                NativeImage nativeImage = NativeImage.read((InputStream)stream);
                return nativeImage;
            }
        }
        throw new IOException("Couldn't find texture " + textureId);
    }

    public void addTexture(String textureId, NativeImage image) throws IOException {
        this.addTexture(textureId, image, false);
    }

    public void addTexture(String textureId, NativeImage image, boolean closeImage) throws IOException {
        block15: {
            if (!textureId.contains(":textures/")) {
                throw new IllegalArgumentException("Invalid texture location: " + textureId);
            }
            String overrideId = textureId.replace(":textures/", ":datagen_texture_overrides/");
            Optional overrideResource = this.rm.getResource(ResourceLocation.parse((String)overrideId));
            if (overrideResource.isPresent()) {
                try (InputStream stream = ((Resource)overrideResource.get()).open();
                     NativeImage overrideImage = NativeImage.read((InputStream)stream);){
                    this.textureWriter.accept(overrideImage, textureId);
                    break block15;
                }
            }
            this.textureWriter.accept(image, textureId);
        }
        this.generatedTextures.add(textureId.replace(":textures/", ":"));
        if (closeImage) {
            image.close();
        }
    }

    public void addMcMeta(String path, MCMetaInfo info) {
        this.mcMetaWriter.accept(this.GSON.toJsonTree((Object)info), path);
    }

    public void runAtEnd(IORunnable runnable) {
        this.endRunnables.add(runnable);
    }

    public CompletableFuture<?> doEndWork() {
        CompletableFuture<Void> ret = CompletableFuture.allOf((CompletableFuture[])this.endRunnables.stream().map(r -> CompletableFuture.runAsync(r::safeRun, Util.backgroundExecutor())).toArray(CompletableFuture[]::new));
        this.endRunnables.clear();
        return ret;
    }

    public void markTexturesAsGenerated(ExistingFileHelper helper) {
        for (String texture : this.generatedTextures) {
            helper.trackGenerated(ResourceLocation.parse((String)texture), PackType.CLIENT_RESOURCES, "", "textures");
        }
    }
}

