/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.jade.server;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.item.ItemNetworkNode;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public class PipeDataProvider
implements IServerDataProvider<BlockAccessor> {
    public ResourceLocation getUid() {
        return MI.id("pipe");
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        PipeBlockEntity be = (PipeBlockEntity)accessor.getBlockEntity();
        for (PipeNetworkNode node : be.getNodes()) {
            Record info;
            CompoundTag pipeData = new CompoundTag();
            if (node instanceof FluidNetworkNode) {
                FluidNetworkNode fluidNode = (FluidNetworkNode)node;
                info = fluidNode.collectNetworkInfo();
                pipeData.put("fluid", ((FluidNetworkNode.InGameInfo)info).fluid().toNbt((HolderLookup.Provider)be.getLevel().registryAccess()));
                pipeData.putLong("amount", ((FluidNetworkNode.InGameInfo)info).stored());
                pipeData.putLong("capacity", ((FluidNetworkNode.InGameInfo)info).capacity());
                pipeData.putLong("transfer", ((FluidNetworkNode.InGameInfo)info).transfer());
                pipeData.putLong("maxTransfer", ((FluidNetworkNode.InGameInfo)info).maxTransfer());
            }
            if (node instanceof ElectricityNetworkNode) {
                ElectricityNetworkNode electricityNode = (ElectricityNetworkNode)node;
                info = electricityNode.collectNetworkInfo();
                pipeData.putLong("eu", ((ElectricityNetworkNode.InGameInfo)info).stored());
                pipeData.putLong("maxEu", ((ElectricityNetworkNode.InGameInfo)info).capacity());
                pipeData.putLong("transfer", ((ElectricityNetworkNode.InGameInfo)info).transfer());
                pipeData.putLong("maxTransfer", ((ElectricityNetworkNode.InGameInfo)info).maxTransfer());
            }
            if (node instanceof ItemNetworkNode) {
                ItemNetworkNode itemNode = (ItemNetworkNode)node;
                info = itemNode.collectNetworkInfo();
                pipeData.putLong("items", ((ItemNetworkNode.InGameInfo)info).movedItems());
                pipeData.putInt("pulse", ((ItemNetworkNode.InGameInfo)info).pulse());
            }
            data.put(node.getType().getIdentifier().toString(), (Tag)pipeData);
        }
    }
}

