/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.definition;

import aztech.modern_industrialization.definition.Definition;
import aztech.modern_industrialization.items.SortOrder;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jspecify.annotations.Nullable;

public class ItemDefinition<T extends Item>
extends Definition
implements ItemLike {
    private final DeferredItem<T> item;
    public final SortOrder sortOrder;
    public final BiConsumer<Item, ItemModelProvider> modelGenerator;
    private @Nullable Consumer<? super T> onItemRegistrationEvent;

    public ItemDefinition(String englishName, DeferredItem<T> item, BiConsumer<Item, ItemModelProvider> modelGenerator, SortOrder sortOrder) {
        super(englishName, item.getId().getPath());
        this.item = item;
        this.modelGenerator = modelGenerator;
        this.onItemRegistrationEvent = null;
        this.sortOrder = sortOrder;
    }

    public ItemDefinition<T> withItemRegistrationEvent(Consumer<? super T> onItemRegistrationEvent) {
        this.onItemRegistrationEvent = onItemRegistrationEvent;
        return this;
    }

    public void onRegister() {
        if (this.onItemRegistrationEvent != null) {
            this.onItemRegistrationEvent.accept(this.item.get());
        }
    }

    public ItemStack stack() {
        return this.stack(1);
    }

    public ItemStack stack(int stackSize) {
        return new ItemStack((ItemLike)this.item.get(), stackSize);
    }

    public boolean is(ItemStack stack) {
        return stack.is(this.item);
    }

    public T asItem() {
        return (T)((Item)this.item.get());
    }

    @Override
    public String getTranslationKey() {
        return ((Item)this.item.get()).getDescriptionId();
    }
}

