/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.helper.EnergyHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public abstract class AbstractStorageMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder {
    protected final EnergyComponent energy;
    private final RedstoneControlComponent redstoneControl;
    protected final MIEnergyStorage insertable;
    protected final MIEnergyStorage extractable;
    protected final long euCapacity;
    protected final CableTier from;
    protected final CableTier to;
    protected boolean extractableOnOutputDirection;

    public AbstractStorageMachineBlockEntity(BEP bep, CableTier from, CableTier to, String name, long euCapacity) {
        this(bep, from, to, name, euCapacity, true);
    }

    public AbstractStorageMachineBlockEntity(BEP bep, CableTier from, CableTier to, String name, long euCapacity, boolean extractableOnOutputDirection) {
        super(bep, new MachineGuiParameters.Builder(name, false).build(), OrientationComponent.Params.noFacing(false, false));
        this.from = from;
        this.to = to;
        this.euCapacity = euCapacity;
        this.energy = new EnergyComponent((BlockEntity)this, euCapacity);
        this.redstoneControl = new RedstoneControlComponent();
        this.insertable = this.energy.buildInsertable(tier -> tier == from);
        this.extractable = this.energy.buildExtractable(tier -> tier == to && this.redstoneControl.doAllowNormalOperation(this));
        this.registerComponents(this.energy, this.redstoneControl);
        EnergyBar.Params energyBarParams = new EnergyBar.Params(76, 39);
        GuiComponentServer[] guiComponentServerArray = new GuiComponentServer[2];
        guiComponentServerArray[0] = new EnergyBar(energyBarParams, this.energy::getEu, this.energy::getCapacity);
        guiComponentServerArray[1] = new SlotPanel(this).withRedstoneControl(this.redstoneControl);
        this.registerGuiComponent(guiComponentServerArray);
        this.extractableOnOutputDirection = extractableOnOutputDirection;
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public static MachineCasing getCasingFromTier(CableTier from, CableTier to) {
        if (from.eu > to.eu) {
            return from.casing;
        }
        return to.casing;
    }

    @Override
    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide()) {
            if (this.extractableOnOutputDirection) {
                EnergyHelper.autoOutput((MachineBlockEntity)this, this.orientation, this.to, this.extractable);
            } else {
                for (Direction side : Direction.values()) {
                    if (side == this.orientation.outputDirection) continue;
                    EnergyHelper.autoOutput((MachineBlockEntity)this, side, this.to, this.extractable);
                }
            }
        }
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }

    @Override
    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ILongEnergyStorage energyItem = (ILongEnergyStorage)player.getItemInHand(hand).getCapability(EnergyApi.ITEM);
        int stackSize = player.getItemInHand(hand).getCount();
        if (energyItem != null) {
            if (!player.level().isClientSide()) {
                Transaction transaction;
                int i;
                boolean insertedSomething = false;
                for (i = 0; i < 10000; ++i) {
                    transaction = Transaction.openRoot();
                    try {
                        long inserted = energyItem.receive(this.energy.getEu() / (long)stackSize, false);
                        if (inserted == 0L) break;
                        insertedSomething = true;
                        this.energy.consumeEu(inserted * (long)stackSize, Simulation.ACT);
                        transaction.commit();
                        continue;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.close();
                        }
                    }
                }
                if (!insertedSomething) {
                    for (i = 0; i < 10000; ++i) {
                        transaction = Transaction.openRoot();
                        try {
                            long extracted = energyItem.extract(this.energy.getRemainingCapacity() / (long)stackSize, false);
                            if (extracted == 0L) break;
                            this.energy.insertEu(extracted * (long)stackSize, Simulation.ACT);
                            transaction.commit();
                            continue;
                        }
                        finally {
                            if (transaction != null) {
                                transaction.close();
                            }
                        }
                    }
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide());
        }
        return super.useItemOn(player, hand, face);
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> {
            AbstractStorageMachineBlockEntity abe = (AbstractStorageMachineBlockEntity)be;
            if (abe.extractableOnOutputDirection) {
                if (abe.orientation.outputDirection == direction) {
                    return abe.extractable;
                }
                return abe.insertable;
            }
            if (abe.orientation.outputDirection == direction) {
                return abe.insertable;
            }
            return abe.extractable;
        }));
    }
}

