/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.DropableComponent;
import aztech.modern_industrialization.machines.models.MachineCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class CasingComponent
implements MachineComponent,
DropableComponent {
    private final @Nullable UpdatedCallback callback;
    private ItemStack casingStack = ItemStack.EMPTY;
    private CableTier currentTier = CableTier.LV;

    public CasingComponent(@Nullable UpdatedCallback callback) {
        this.callback = callback;
    }

    public CasingComponent() {
        this(null);
    }

    private void setCasingStack(ItemStack stack) {
        this.casingStack = stack;
        this.currentTier = CasingComponent.getCasingTier(stack.getItem());
        if (this.currentTier == null) {
            this.currentTier = CableTier.LV;
        }
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("casing", this.casingStack.saveOptional(registries));
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.setCasingStack(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("casing")));
    }

    @Override
    public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putString("casing", this.currentTier.name);
    }

    @Override
    public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
        this.currentTier = CableTier.getTier(tag.getString("casing"));
    }

    public CableTier getCableTier() {
        return this.currentTier;
    }

    public void dropCasing(Level world, BlockPos pos) {
        Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.casingStack);
    }

    public ItemInteractionResult onUse(MachineBlockEntity be, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.getCount() >= 1) {
            CableTier previousTier = this.currentTier;
            CableTier newTier = CasingComponent.getCasingTier(stackInHand.getItem());
            if (newTier != null && newTier != this.currentTier) {
                if (this.currentTier != CableTier.LV) {
                    this.dropCasing(be.getLevel(), be.getBlockPos());
                }
                this.setCasingStack(stackInHand.copyWithCount(1));
                stackInHand.consume(1, (LivingEntity)player);
                be.setChanged();
                if (!be.getLevel().isClientSide()) {
                    be.sync();
                }
                be.getLevel().updateNeighborsAt(be.getBlockPos(), Blocks.AIR);
                this.playCasingPlaceSound(be);
                if (this.callback != null) {
                    this.callback.onUpdated(previousTier, this.currentTier);
                }
                return ItemInteractionResult.sidedSuccess((boolean)be.getLevel().isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void playCasingPlaceSound(MachineBlockEntity be) {
        ResourceLocation blockKey = this.currentTier.itemKey;
        if (blockKey == null) {
            return;
        }
        BuiltInRegistries.BLOCK.getOptional(blockKey).ifPresent(block -> {
            BlockState casingState = block.defaultBlockState();
            SoundType group = casingState.getSoundType();
            SoundEvent sound = group.getBreakSound();
            be.getLevel().playSound(null, be.getBlockPos(), sound, SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 4.0f, group.getPitch() * 0.8f);
        });
    }

    public static @Nullable CableTier getCasingTier(Item item) {
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)item);
        for (CableTier tier : CableTier.allTiers()) {
            if (tier.itemKey == null || !tier.itemKey.equals((Object)itemKey)) continue;
            return tier;
        }
        return null;
    }

    @Override
    public ItemStack getDrop() {
        return this.casingStack;
    }

    public void setCasingServer(MachineBlockEntity be, ItemStack casing) {
        CableTier previousTier = this.currentTier;
        this.setCasingStack(casing);
        be.setChanged();
        be.sync();
        be.getLevel().updateNeighborsAt(be.getBlockPos(), Blocks.AIR);
        this.playCasingPlaceSound(be);
        if (this.callback != null && previousTier != this.currentTier) {
            this.callback.onUpdated(previousTier, this.currentTier);
        }
    }

    public MachineCasing getCasing() {
        return this.currentTier.casing;
    }

    public boolean canInsertEu(CableTier tier) {
        return tier == this.currentTier;
    }

    public long getEuCapacity() {
        return this.currentTier.getEu() * 100L;
    }

    @FunctionalInterface
    public static interface UpdatedCallback {
        public void onUpdated(CableTier var1, CableTier var2);
    }
}

