/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jspecify.annotations.Nullable;

public class OrientationComponent
implements MachineComponent {
    public Direction facingDirection = Direction.NORTH;
    public Direction outputDirection = null;
    public boolean extractItems = false;
    public boolean extractFluids = false;
    public final Params params;
    private final BlockEntity machine;

    public OrientationComponent(Params params, BlockEntity machine) {
        this.params = params;
        if (params.hasOutput) {
            this.outputDirection = Direction.NORTH;
        }
        this.machine = machine;
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        if (this.params.hasFacing) {
            this.facingDirection = Direction.from3DDataValue((int)tag.getInt("facingDirection"));
        }
        if (this.params.hasOutput) {
            this.outputDirection = Direction.from3DDataValue((int)tag.getInt("outputDirection"));
        }
        this.extractItems = tag.getBoolean("extractItems");
        this.extractFluids = tag.getBoolean("extractFluids");
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.params.hasFacing) {
            tag.putInt("facingDirection", this.facingDirection.get3DDataValue());
        }
        if (this.params.hasOutput) {
            tag.putInt("outputDirection", this.outputDirection.get3DDataValue());
        }
        if (this.extractItems) {
            tag.putBoolean("extractItems", true);
        }
        if (this.extractFluids) {
            tag.putBoolean("extractFluids", true);
        }
    }

    public void writeModelData(MachineModelClientData data) {
        if (this.params.hasFacing) {
            data.frontDirection = this.facingDirection;
        }
        if (this.params.hasOutput) {
            data.outputDirection = this.outputDirection;
            data.itemAutoExtract = this.extractItems;
            data.fluidAutoExtract = this.extractFluids;
        }
    }

    public boolean useWrench(Player player, InteractionHand hand, Direction face) {
        if (player.isShiftKeyDown()) {
            if (this.params.hasOutput) {
                this.outputDirection = face;
                this.machine.invalidateCapabilities();
                return true;
            }
        } else if (this.params.hasFacing) {
            if (this.params.canBeVertical || face.getAxis().isHorizontal()) {
                this.facingDirection = face;
            }
            return true;
        }
        return false;
    }

    public void onPlaced(@Nullable LivingEntity placer, ItemStack itemStack) {
        if (this.params.hasFacing) {
            Direction dir = placer != null ? (this.params.canBeVertical ? placer.getNearestViewDirection() : placer.getDirection()) : Direction.NORTH;
            this.facingDirection = dir.getOpposite();
        }
        if (this.params.hasOutput) {
            this.outputDirection = placer != null ? placer.getNearestViewDirection() : Direction.NORTH;
        }
    }

    public static class Params {
        public final boolean hasFacing;
        public final boolean hasOutput;
        public final boolean hasExtractItems;
        public final boolean hasExtractFluids;
        public final boolean canBeVertical;

        private Params(boolean hasFacing, boolean hasOutput, boolean hasExtractItems, boolean hasExtractFluids, boolean canBeVertical) {
            this.hasFacing = hasFacing;
            this.hasOutput = hasOutput;
            this.hasExtractItems = hasExtractItems;
            this.hasExtractFluids = hasExtractFluids;
            this.canBeVertical = canBeVertical;
        }

        public Params(boolean hasOutput, boolean hasExtractItems, boolean hasExtractFluids, boolean canBeVertical) {
            this(true, hasOutput, hasExtractItems, hasExtractFluids, canBeVertical);
        }

        public Params(boolean hasOutput, boolean hasExtractItems, boolean hasExtractFluids) {
            this(hasOutput, hasExtractItems, hasExtractFluids, false);
        }

        public static Params noFacingNoOutput() {
            return Params.noFacingNoOutput(false, false);
        }

        public static Params noFacingNoOutput(boolean hasExtractItems, boolean hasExtractFluids) {
            return new Params(false, false, hasExtractItems, hasExtractFluids, false);
        }

        public static Params noFacing(boolean hasExtractItems, boolean hasExtractFluids) {
            return new Params(false, true, hasExtractItems, hasExtractFluids, false);
        }
    }
}

