/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.api.datamaps.MachineUpgrade;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.DropableComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UpgradeComponent
implements MachineComponent.ServerOnly,
DropableComponent {
    private ItemStack itemStack = ItemStack.EMPTY;

    public static long getExtraEu(ItemLike item) {
        MachineUpgrade data = (MachineUpgrade)item.asItem().builtInRegistryHolder().getData(MIDataMaps.MACHINE_UPGRADES);
        return data == null ? 0L : (long)data.extraMaxEu();
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("upgradesItemStack", this.itemStack.saveOptional(registries));
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("upgradesItemStack"));
    }

    public ItemInteractionResult onUse(MachineBlockEntity be, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (UpgradeComponent.getExtraEu((ItemLike)stackInHand.getItem()) > 0L) {
            boolean changed = false;
            if (this.itemStack.isEmpty()) {
                this.itemStack = stackInHand.copy();
                if (!player.isCreative()) {
                    stackInHand.setCount(0);
                }
                changed = true;
            } else if (stackInHand.getItem() == this.itemStack.getItem()) {
                int maxAdded = Math.min(stackInHand.getCount(), this.itemStack.getMaxStackSize() - this.itemStack.getCount());
                changed = maxAdded > 0;
                this.itemStack.grow(maxAdded);
                stackInHand.consume(maxAdded, (LivingEntity)player);
            }
            if (changed) {
                be.setChanged();
                if (!be.getLevel().isClientSide()) {
                    be.sync();
                }
                return ItemInteractionResult.sidedSuccess((boolean)be.getLevel().isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public long getAddMaxEUPerTick() {
        if (this.itemStack.isEmpty()) {
            return 0L;
        }
        return (long)this.itemStack.getCount() * UpgradeComponent.getExtraEu((ItemLike)this.itemStack.getItem());
    }

    @Override
    public ItemStack getDrop() {
        return this.itemStack;
    }

    public void setStackServer(MachineBlockEntity be, ItemStack stack) {
        this.itemStack = stack;
        be.setChanged();
        be.sync();
    }

    static {
        KubeJSProxy.instance.fireRegisterUpgradesEvent();
    }
}

