/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListener;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListeners;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class ShapeMatcher
implements ChunkEventListener {
    protected final BlockPos controllerPos;
    protected final ShapeTemplate template;
    protected final Map<BlockPos, SimpleMember> simpleMembers;
    protected final Map<BlockPos, HatchFlags> hatchFlags;
    private boolean needsRematch = true;
    private boolean matchSuccessful = false;
    private final List<HatchBlockEntity> matchedHatches = new ArrayList<HatchBlockEntity>();

    public ShapeMatcher(Level world, BlockPos controllerPos, Direction controllerDirection, ShapeTemplate template) {
        this.controllerPos = controllerPos;
        this.template = template;
        this.simpleMembers = ShapeMatcher.toWorldPos(controllerPos, controllerDirection, template.simpleMembers);
        this.hatchFlags = ShapeMatcher.toWorldPos(controllerPos, controllerDirection, template.hatchFlags);
    }

    public static BlockPos toWorldPos(BlockPos controllerPos, Direction controllerDirection, BlockPos templatePos) {
        BlockPos rotatedPos = controllerDirection == Direction.NORTH ? new BlockPos(-templatePos.getX(), templatePos.getY(), templatePos.getZ()) : (controllerDirection == Direction.SOUTH ? new BlockPos(templatePos.getX(), templatePos.getY(), -templatePos.getZ()) : (controllerDirection == Direction.EAST ? new BlockPos(-templatePos.getZ(), templatePos.getY(), -templatePos.getX()) : new BlockPos(templatePos.getZ(), templatePos.getY(), templatePos.getX())));
        return rotatedPos.offset((Vec3i)controllerPos);
    }

    protected static <V> Map<BlockPos, V> toWorldPos(BlockPos controllerPos, Direction controllerDirection, Map<BlockPos, V> templateMap) {
        HashMap<BlockPos, V> result = new HashMap<BlockPos, V>();
        for (Map.Entry<BlockPos, V> entry : templateMap.entrySet()) {
            result.put(ShapeMatcher.toWorldPos(controllerPos, controllerDirection, entry.getKey()), entry.getValue());
        }
        return result;
    }

    public Set<BlockPos> getPositions() {
        return new HashSet<BlockPos>(this.simpleMembers.keySet());
    }

    public SimpleMember getSimpleMember(BlockPos pos) {
        return Objects.requireNonNull(this.simpleMembers.get(pos));
    }

    public @Nullable HatchFlags getHatchFlags(BlockPos pos) {
        return this.hatchFlags.get(pos);
    }

    public List<HatchBlockEntity> getMatchedHatches() {
        return Collections.unmodifiableList(this.matchedHatches);
    }

    public void unlinkHatches() {
        for (HatchBlockEntity hatch : this.matchedHatches) {
            hatch.unlink();
        }
        this.matchedHatches.clear();
        this.matchSuccessful = false;
        this.needsRematch = true;
    }

    public boolean matches(BlockPos pos, Level world) {
        SimpleMember simpleMember = this.simpleMembers.get(pos);
        if (simpleMember == null) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        if (simpleMember.matchesState(state)) {
            return true;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof HatchBlockEntity) {
            HatchBlockEntity hatch = (HatchBlockEntity)be;
            HatchFlags flags = this.hatchFlags.get(pos);
            if (flags != null && flags.allows(hatch.getHatchType()) && !hatch.isMatched()) {
                this.matchedHatches.add(hatch);
                return true;
            }
        }
        return false;
    }

    public boolean needsRematch() {
        return this.needsRematch;
    }

    public boolean isMatchSuccessful() {
        return this.matchSuccessful && !this.needsRematch;
    }

    protected boolean checkRematch(Level world) {
        return true;
    }

    public void rematch(Level world) {
        this.unlinkHatches();
        this.matchSuccessful = true;
        for (BlockPos pos : this.simpleMembers.keySet()) {
            if (this.matches(pos, world)) continue;
            this.matchSuccessful = false;
        }
        if (!this.checkRematch(world)) {
            this.matchSuccessful = false;
        }
        if (!this.matchSuccessful) {
            this.matchedHatches.clear();
        } else {
            for (HatchBlockEntity hatch : this.matchedHatches) {
                hatch.link(this.template.hatchCasing);
            }
        }
        this.needsRematch = false;
    }

    public Set<ChunkPos> getSpannedChunks() {
        HashSet<ChunkPos> spannedChunks = new HashSet<ChunkPos>();
        for (BlockPos pos : this.simpleMembers.keySet()) {
            spannedChunks.add(new ChunkPos(pos));
        }
        return spannedChunks;
    }

    public void registerListeners(Level world) {
        for (ChunkPos chunkPos : this.getSpannedChunks()) {
            ChunkEventListeners.listeners.add((LevelAccessor)world, chunkPos, this);
        }
    }

    public void unregisterListeners(Level world) {
        for (ChunkPos chunkPos : this.getSpannedChunks()) {
            ChunkEventListeners.listeners.remove((LevelAccessor)world, chunkPos, this);
        }
    }

    public int buildMultiblock(Level level) {
        int setBlocks = 0;
        for (Map.Entry<BlockPos, SimpleMember> entry : this.simpleMembers.entrySet()) {
            BlockState current = level.getBlockState(entry.getKey());
            if (entry.getValue().matchesState(current)) continue;
            level.setBlockAndUpdate(entry.getKey(), entry.getValue().getPreviewState());
            ++setBlocks;
        }
        return setBlocks;
    }

    @Override
    public void onBlockUpdate(BlockPos pos) {
        if (this.simpleMembers.containsKey(pos)) {
            this.needsRematch = true;
        }
    }

    @Override
    public void onUnload() {
        this.needsRematch = true;
    }

    @Override
    public void onLoad() {
        this.needsRematch = true;
    }
}

