/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.loading.FMLPaths;

public class ConflictsChecker {
    public static Path writeConflictReport(ServerLevel level) throws IOException {
        Object finalReport;
        StringBuilder conflictsReport = new StringBuilder();
        int conflictCount = 0;
        int conflictTypeCount = 0;
        for (MachineRecipeType type : MIMachineRecipeTypes.getRecipeTypes()) {
            TreeMap<ResourceLocation, List> conflicts = new TreeMap<ResourceLocation, List>();
            for (RecipeHolder<MachineRecipe> recipeHolder : type.getRecipesWithCache(level)) {
                List<ConfigurableItemStack> itemConfStacks = ((MachineRecipe)recipeHolder.value()).itemInputs.stream().map(input -> {
                    ConfigurableItemStack confStack = new ConfigurableItemStack();
                    Item item = input.getInputItems().stream().findFirst().orElse(Items.AIR);
                    confStack.setKey(ItemVariant.of((ItemLike)item));
                    confStack.setAmount(Integer.MAX_VALUE);
                    return confStack;
                }).toList();
                List<ConfigurableFluidStack> fluidConfStacks = ((MachineRecipe)recipeHolder.value()).fluidInputs.stream().map(input -> {
                    ConfigurableFluidStack confStack = new ConfigurableFluidStack(Integer.MAX_VALUE);
                    Fluid fluid = input.getInputFluids().stream().findFirst().orElse(Fluids.EMPTY);
                    confStack.setKey(FluidVariant.of(fluid));
                    confStack.setAmount(Integer.MAX_VALUE);
                    return confStack;
                }).toList();
                for (RecipeHolder<MachineRecipe> otherRecipe : CrafterComponent.getRecipes(level, type, itemConfStacks)) {
                    if (otherRecipe.id().equals((Object)recipeHolder.id()) || !CrafterComponent.doInputsMatch(itemConfStacks, fluidConfStacks, (MachineRecipe)otherRecipe.value())) continue;
                    conflicts.computeIfAbsent(recipeHolder.id(), i -> new ArrayList()).add(otherRecipe.id());
                    ++conflictCount;
                }
            }
            if (conflicts.isEmpty()) continue;
            ++conflictTypeCount;
            conflictsReport.append("\n\n");
            conflictsReport.append("Conflicts for ").append(type.getId()).append(":\n");
            for (Map.Entry entry : conflicts.entrySet()) {
                conflictsReport.append("- ").append(entry.getKey()).append(" conflicts with:\n");
                Collections.sort((List)entry.getValue());
                for (ResourceLocation other : (List)entry.getValue()) {
                    conflictsReport.append("  - ").append(other).append("\n");
                }
            }
        }
        if (conflictsReport.isEmpty()) {
            finalReport = "No conflicts found! Note that the detection is approximate.\n";
        } else {
            finalReport = "Found " + conflictCount + " conflicts over " + conflictTypeCount + " recipe types!\n";
            finalReport = (String)finalReport + conflictsReport.toString();
        }
        Path filePath = FMLPaths.GAMEDIR.get().resolve("modern_industrialization").resolve("recipe_conflicts.txt");
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));){
            os.write(((String)finalReport).getBytes(StandardCharsets.UTF_8));
        }
        return filePath;
    }
}

