/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.RelativePosition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public record AdjacentBlockProcessCondition(Block block, RelativePosition relativePosition) implements MachineProcessCondition
{
    static final MapCodec<AdjacentBlockProcessCondition> CODEC = RecordCodecBuilder.mapCodec(g -> g.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(c -> c.block), (App)StringRepresentable.fromEnum(RelativePosition::values).fieldOf("position").forGetter(c -> c.relativePosition)).apply((Applicative)g, AdjacentBlockProcessCondition::new));
    static final StreamCodec<RegistryFriendlyByteBuf, AdjacentBlockProcessCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), AdjacentBlockProcessCondition::block, (StreamCodec)ByteBufCodecs.fromCodec((Codec)StringRepresentable.fromEnum(RelativePosition::values)), AdjacentBlockProcessCondition::relativePosition, AdjacentBlockProcessCondition::new);

    public AdjacentBlockProcessCondition(Block block, String relativePosition) {
        this(block, RelativePosition.valueOf(relativePosition.toUpperCase(Locale.ROOT)));
    }

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        return switch (this.relativePosition) {
            default -> throw new MatchException(null, null);
            case RelativePosition.BELOW -> {
                BlockPos checkPos = context.getBlockEntity().getBlockPos().below();
                yield context.getLevel().getBlockState(checkPos).is(this.block);
            }
            case RelativePosition.BEHIND -> {
                OrientationComponent orientation = context.getBlockEntity().orientation;
                if (!orientation.params.hasFacing) {
                    yield false;
                }
                Direction direction = orientation.facingDirection;
                BlockPos checkPos = context.getBlockEntity().getBlockPos().relative(direction.getOpposite());
                yield context.getLevel().getBlockState(checkPos).is(this.block);
            }
        };
    }

    @Override
    public void appendDescription(List<Component> list) {
        MIText text = switch (this.relativePosition) {
            default -> throw new MatchException(null, null);
            case RelativePosition.BELOW -> MIText.RequiresBlockBelow;
            case RelativePosition.BEHIND -> MIText.RequiresBlockBehind;
        };
        list.add((Component)text.text(this.block.getName()));
    }

    @Override
    public ItemStack icon() {
        return this.block.asItem().getDefaultInstance();
    }

    @Override
    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }
}

