/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MICommonProxy;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.tank.TankBlock;
import aztech.modern_industrialization.blocks.storage.tank.TankBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.TankItem;
import aztech.modern_industrialization.datagen.model.BaseModelProvider;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.PartEnglishNameFormatter;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import java.util.function.BiConsumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jspecify.annotations.Nullable;

public class TankPart
implements PartKeyProvider {
    public static final BiConsumer<Block, BaseModelProvider> MODEL_GENERATOR = (block, gen) -> gen.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)gen.models().getBuilder(gen.blockTexture(block).getPath())).parent((ModelFile)gen.models().getExistingFile(gen.modLoc("base/tank")))).texture("0", gen.blockTexture(block).toString()));

    @Override
    public PartKey key() {
        return new PartKey("tank");
    }

    public PartTemplate of(String nameOverride, String path, int bucketCapacity) {
        return this.of(new PartEnglishNameFormatter.Overridden(nameOverride), bucketCapacity, path);
    }

    public PartTemplate of(long bucketCapacity) {
        return this.of(new PartEnglishNameFormatter.Default("Tank"), bucketCapacity, null);
    }

    public PartTemplate of(PartEnglishNameFormatter englishNameFormatter, long bucketCapacity, @Nullable String maybePathOverridden) {
        MutableObject bet = new MutableObject();
        long capacity = 1000L * bucketCapacity;
        PartTemplate tank = new PartTemplate(englishNameFormatter, this.key()).asBlock(SortOrder.TANKS, new TextureGenParams.SimpleRecoloredBlock()).withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> {
            StorageBehaviour tankStorageBehaviour = StorageBehaviour.uniformQuantity(capacity);
            EntityBlock factory = (pos, state) -> new TankBlockEntity((BlockEntityType)bet.getValue(), pos, state);
            BlockDefinition<TankBlock> blockDefinition = MIBlock.block(englishName, itemPath, MIBlock.BlockDefinitionParams.defaultStone().withBlockConstructor(s -> new TankBlock(factory, tankStorageBehaviour)).withBlockItemConstructor(TankItem::new).withModel(MODEL_GENERATOR).withBlockEntityRendererItemModel().noLootTable().sortOrder(SortOrder.TANKS.and(Long.valueOf(bucketCapacity))));
            TagsToGenerate.generateTag(MITags.TANKS, blockDefinition, "Tanks");
            MIRegistries.BLOCK_ENTITIES.register(itemPath, () -> {
                BlockEntityType ret = BlockEntityType.Builder.of((arg_0, arg_1) -> ((EntityBlock)factory).newBlockEntity(arg_0, arg_1), (Block[])new Block[]{blockDefinition.asBlock()}).build(null);
                bet.setValue((Object)ret);
                return ret;
            });
            MICapabilities.onEvent(event -> {
                event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)bet.getValue(), (be, side) -> be.fluidHandler);
                TankItem item = (TankItem)blockDefinition.asItem();
                event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ignored) -> new ContainerItem.FluidHandler((ItemStack)stack, item), new ItemLike[]{item});
            });
            MICommonProxy.INSTANCE.registerPartTankClient(() -> ((MutableObject)bet).getValue(), partContext.get(MaterialProperty.MEAN_RGB));
        });
        if (maybePathOverridden != null) {
            tank = tank.withCustomPath(maybePathOverridden);
        }
        return tank;
    }
}

